//
//  CalendarMasterViewController.h
//  Fabiji
//
//  Created by Zhao He on 19/01/12.
//  Copyright (c) 2012 Media Computing Group, RWTH Aachen University. All rights reserved.
//

#import <UIKit/UIKit.h>
#import <EventKit/EventKit.h>
#import "FABCalendarDetailViewController.h"
#import "FABAppointment.h"

@interface FABCalendarMasterViewController : UITableViewController

@property (retain, nonatomic) EKEventStore *eventStore;
@property (retain, nonatomic) NSDate *appointmentDate;
@property (retain, nonatomic) NSCalendar *gregorian;
@property (retain, nonatomic) NSMutableArray *appointments;
@property (retain, nonatomic) IBOutlet FABCalendarDetailViewController *detailViewController;
@property (retain, nonatomic) IBOutlet UIView *headerView;
@property (retain, nonatomic) IBOutlet UILabel *appointmentDateLabel;

@property (retain, nonatomic) NSArray *events;

- (IBAction)reloadEvents:(id)sender;
- (IBAction)segmentAction:(id)sender;
- (IBAction)todayEvents:(id)sender;


- (NSDate *)beginningOfDay:(NSDate*)date;
- (void)setAppointmentDateLabel;

@end


