//
//  CalendarDetailViewController.m
//  Fabiji
//
//  Created by Zhao He on 24/01/2012.
//  Copyright (c) 2012 Media Computing Group, RWTH Aachen University. All rights reserved.
//

#import "FABCalendarDetailViewController.h"
#import "FABProjectsDetailViewController.h"

@implementation FABCalendarDetailViewController

@synthesize detailItem = _detailItem;
@synthesize fromLabel = _fromLabel;
@synthesize startsLabel = _startsLabel;
@synthesize endsLabel = _endsLabel;
@synthesize notesTextView = _notesTextView;
@synthesize navigationBar = _navigationBar;
@synthesize navigationItem = _myNavigationItem;
@synthesize loginBarButtonItem = _startBarButtonItem;
@synthesize indicateLabelCollection = _indicateLabelCollection;


- (void)dealloc
{
    [_detailItem release];
    [_fromLabel release];
    [_navigationBar release];
    [_myNavigationItem release];
    [_startBarButtonItem release];
    [_startsLabel release];
    [_endsLabel release];
    [_notesTextView release];
    [_indicateLabelCollection release];
    [super dealloc];
}


#pragma mark - Managing the detail item

- (void)setDetailItem:(id)newDetailItem
{
    if (_detailItem != newDetailItem) {
        [_detailItem release]; 
        _detailItem = [newDetailItem retain]; 
        
        // Update the view.
        [self configureView];
    }
}

- (IBAction)loginButtonTapped:(id)sender 
{
    // Jump to "My Projects" tab
    [self.parentViewController.tabBarController setSelectedIndex:3];

    // Hide detail view
    UINavigationController *nav = [self.parentViewController.tabBarController.viewControllers objectAtIndex:3];
    UISplitViewController *split = [nav.viewControllers lastObject];
    FABProjectsDetailViewController *detail = [split.viewControllers lastObject];
    [detail.view setNeedsDisplay];
    detail.scrollView.hidden = YES;
    
    // Perform selector for action sheet "Log In As"
    [detail logInAsTapped];
}

- (void)configureView
{ 
    if (self.detailItem) 
    {                
        NSDateFormatter *dateFormat = [[NSDateFormatter alloc] init];
        [dateFormat setDateFormat:@"HH:mm"];
        
        NSString *startDateString = [dateFormat stringFromDate:self.detailItem.startDate];
        NSString *endDateString = [dateFormat stringFromDate:self.detailItem.endDate];
        
        self.loginBarButtonItem.enabled = YES;
        
        for (UILabel *label in self.indicateLabelCollection) 
        {
            label.hidden = NO;
        }
        
        self.navigationItem.title = self.detailItem.title;
        self.fromLabel.text = self.detailItem.attendeeName;
        self.startsLabel.text = startDateString;
        self.endsLabel.text = endDateString;
        self.notesTextView.text = self.detailItem.notes;
        
        [dateFormat release];
    }
}

#pragma mark - View lifecycle

- (void)viewDidLoad
{
    [super viewDidLoad];
    
    self.fromLabel.text = @"";
    self.startsLabel.text = @"";
    self.endsLabel.text = @"";
    self.notesTextView.text = @"";
    
    self.loginBarButtonItem.enabled = NO;
    
    for (UILabel *label in self.indicateLabelCollection) 
    {
        label.hidden = YES;
    }
    
    [self configureView];
}

- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation
{
    return YES;
}

#pragma mark - Split view controller delegations

- (void)splitViewController:(UISplitViewController *)splitController willHideViewController:(UIViewController *)viewController withBarButtonItem:(UIBarButtonItem *)barButtonItem forPopoverController:(UIPopoverController *)popoverController
{
    // From landscape to portrait    
    barButtonItem.title = @"Appointments";
    [self.navigationBar.topItem setLeftBarButtonItem:barButtonItem animated:YES];
}

- (void)splitViewController:(UISplitViewController *)splitController willShowViewController:(UIViewController *)viewController invalidatingBarButtonItem:(UIBarButtonItem *)barButtonItem
{
    // From portrait to landscape
    [self.navigationBar.topItem setLeftBarButtonItem:nil animated:YES];
}

- (BOOL)splitViewController:(UISplitViewController *)svc shouldHideViewController:(UIViewController *)vc inOrientation:(UIInterfaceOrientation)orientation
{
    return NO;
    //return UIInterfaceOrientationIsPortrait(orientation);
}

- (void)viewDidUnload {
    [self setStartsLabel:nil];
    [self setEndsLabel:nil];
    [self setNotesTextView:nil];
    [self setIndicateLabelCollection:nil];
    [self setLoginBarButtonItem:nil];
    [super viewDidUnload];
}
@end
