//
//  AppDelegate.m
//  Fabiji
//
//  Created by Zhao He on 19/01/12.
//  Copyright (c) 2012 Media Computing Group, RWTH Aachen University. All rights reserved.
//

#import "FABAppDelegate.h"
#import "FABSHKConfigurator.h"
#import "FABRestHelper.h"
#import "SHKConfiguration.h"
#import "SHKFacebook.h"
#import <RestKit/RestKit.h>


@implementation FABAppDelegate

@synthesize window = _window;
@synthesize tabBarController = _tabBarController;
@synthesize calendarVC = _calendarVC;
@synthesize galleryVC = _galleryVC;
@synthesize inspireVC = _inspireVC;
@synthesize myProjectsVC = _myProjectsVC;


- (void)dealloc
{
    [_window release];
    [_tabBarController release];
    [_calendarVC release];
    [_galleryVC release];
    [_inspireVC release];
    [_myProjectsVC release];
    [super dealloc];
}

- (BOOL)application:(UIApplication *)application didFinishLaunchingWithOptions:(NSDictionary *)launchOptions
{
    // Initialize RestKit
    [FABRestHelper initBackendCommunication];
    
    // Load ShareKit submodule with app specific configuration
    DefaultSHKConfigurator *configurator = [[[FABSHKConfigurator alloc] init] autorelease];
    [SHKConfiguration sharedInstanceWithConfigurator:configurator];
    
    _window = [[UIWindow alloc] initWithFrame:[[UIScreen mainScreen] bounds]];
    [[NSBundle mainBundle] loadNibNamed:@"FABMainViews" owner:self options:nil];
    
    NSMutableArray *viewControllers = [[NSMutableArray alloc] init];
    NSMutableArray *tabBarItems = [[NSMutableArray alloc] init];
    NSArray *tabBarItemTitles = [NSArray arrayWithObjects:@"Calendar", @"Gallery", @"Inspire Me", @"My Projects", nil];
    
    UIImage *calendarImage = [UIImage imageWithContentsOfFile:[[NSBundle mainBundle] pathForResource:@"tab_calendar" ofType:@"png"]];
    UIImage *galleryImage = [UIImage imageWithContentsOfFile:[[NSBundle mainBundle] pathForResource:@"tab_gallery" ofType:@"png"]];
    UIImage *inspireMeImage = [UIImage imageWithContentsOfFile:[[NSBundle mainBundle] pathForResource:@"tab_inspireMe" ofType:@"png"]];
    UIImage *myProjectsImage = [UIImage imageWithContentsOfFile:[[NSBundle mainBundle] pathForResource:@"tab_myProjects" ofType:@"png"]];

    NSArray *tabIcons = [NSArray arrayWithObjects:calendarImage, galleryImage, inspireMeImage, myProjectsImage, nil];
    
    for (int i = 0; i < [tabBarItemTitles count]; i++)
    {
        UITabBarItem *tab = [[UITabBarItem alloc] initWithTitle:[tabBarItemTitles objectAtIndex:i] image:[tabIcons objectAtIndex:i] tag:i];
        [tabBarItems addObject:tab];
        [tab release];
    }
    
    self.inspireVC = [[[FABInspireViewController alloc] init] autorelease];
    self.galleryVC = [[[FABGalleryPhotoViewController alloc] init] autorelease];
    
    // Put UISlitViewController inside UINavigationController 
    // and later hide the navigation bar
    UINavigationController *galleryNavigationController = [[UINavigationController alloc] initWithRootViewController:self.galleryVC];
    galleryNavigationController.tabBarItem = [tabBarItems objectAtIndex:1];
    
    UINavigationController *myProjectNavigationController = [[UINavigationController alloc] init];
    myProjectNavigationController.viewControllers = [NSArray arrayWithObject:self.myProjectsVC];
    myProjectNavigationController.tabBarItem = [tabBarItems objectAtIndex:3];
    
    self.calendarVC.tabBarItem = [tabBarItems objectAtIndex:0];
    self.inspireVC.tabBarItem = [tabBarItems objectAtIndex:2];
    
    [viewControllers addObject:[self calendarVC]];
    [viewControllers addObject:galleryNavigationController];
    [viewControllers addObject:[self inspireVC]];
    [viewControllers addObject:myProjectNavigationController];
    
    [self.tabBarController setViewControllers:viewControllers];
    [self.window setRootViewController:self.tabBarController];
    [self.window makeKeyAndVisible];
    
    
    [galleryNavigationController release];
    [myProjectNavigationController release];
    [tabBarItems release];
    [viewControllers release];
    
    // Flush offline queue
    [self performSelector:@selector(testOffline) withObject:nil afterDelay:0.5];
    
    return YES;
}


#pragma mark - SSO for Facebook

- (void)testOffline
{	
	[SHK flushOfflineQueue];
}

- (BOOL)handleOpenURL:(NSURL*)url
{
    NSString* scheme = [url scheme];
    NSString* prefix = [NSString stringWithFormat:@"fb%@", SHKCONFIG(facebookAppId)];
    if ([scheme hasPrefix:prefix])
        return [SHKFacebook handleOpenURL:url];
    return YES;
}

- (BOOL)application:(UIApplication *)application openURL:(NSURL *)url sourceApplication:(NSString *)sourceApplication annotation:(id)annotation 
{
    return [self handleOpenURL:url];
}

- (BOOL)application:(UIApplication *)application handleOpenURL:(NSURL *)url 
{
    return [self handleOpenURL:url];  
}

@end
