//
//  VDSVicon.h
//  ViconDataStreamFramework
//
//  Created by Chatchavan Wacharamanotham on 28/03/2011.
//  Copyright 2011 Media Computing Group, RWTH Aachen. All rights reserved.
//

#import <Foundation/Foundation.h>

@class VDSVicon;
@class VDSDiscoveryStub;
@class VDSCommandStub;

// =================================================================================================================
@protocol VDSViconDelegate <NSObject>
// =================================================================================================================

@required

// status
-(void)viconIsReady:(VDSVicon*)theVicon;


@optional

// marker stream
-(void)vicon:(VDSVicon*)theVicon DidReceiveUnlabeledMarkers:(NSDictionary *)theMarkers atFrame:(NSInteger)theFrame;

@end
// =================================================================================================================



// =================================================================================================================
@interface VDSVicon : NSObject 
// =================================================================================================================
{

@private
    id <VDSViconDelegate> delegate;
    VDSDiscoveryStub *discoveryStub;
    VDSCommandStub *commandStub;
    NSMutableDictionary *keyedStreamStubs;

}

@property (assign) id <VDSViconDelegate> delegate;

// -----------------------------------------------------------------------------------------------------------------
#pragma mark -
#pragma mark inits
// -----------------------------------------------------------------------------------------------------------------

// designated initializer
-(id)initWithIPAddress:(NSString *)theIPAddress andPort:(NSInteger)thePort;

-(id)initWithBonjour;


// -----------------------------------------------------------------------------------------------------------------
#pragma mark -
#pragma mark marker stream control
// -----------------------------------------------------------------------------------------------------------------

// selector format:
// unlabeled marker  [theTarget didReceiveFrame: markers:]
// TODO: labeled marker
-(void)startStream:(NSString *)theType withTarget:(id)theTarget andSelector:(SEL)theSelector;

-(void)stopStream:(NSString *)theType;


@end
// =================================================================================================================
