package de.test.contacts;

import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.database.Cursor;
import android.os.Bundle;
import android.provider.BaseColumns;
import android.provider.ContactsContract;
import android.provider.ContactsContract.CommonDataKinds.Phone;
import android.util.Log;

public class main extends Activity {

	/** Called when the activity is first created. */
	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.main);

		getContactNumbers(this);
	}

	public static void getContactNumbers(Context context) {
		String contactNumber;
		int contactNumberType;
		String nameOfContact;

		ContentResolver cr = context.getContentResolver();
		Cursor cur = cr.query(ContactsContract.Contacts.CONTENT_URI, null,
				null, null, null);

		if (cur.getCount() > 0) {
			while (cur.moveToNext()) {
				String id = cur.getString(cur.getColumnIndex(BaseColumns._ID));
				nameOfContact = cur
						.getString(cur
								.getColumnIndex(ContactsContract.Contacts.DISPLAY_NAME));

				if (Integer
						.parseInt(cur
								.getString(cur
										.getColumnIndex(ContactsContract.Contacts.HAS_PHONE_NUMBER))) > 0) {
					Cursor phones = cr.query(
							ContactsContract.CommonDataKinds.Phone.CONTENT_URI,
							null,
							ContactsContract.CommonDataKinds.Phone.CONTACT_ID
									+ " = ?", new String[] { id }, null);

					while (phones.moveToNext()) {
						contactNumber = phones.getString(phones
								.getColumnIndex(Phone.NUMBER));
						contactNumberType = phones.getInt(phones
								.getColumnIndex(Phone.TYPE));
						Log.i("test", "Name: " + nameOfContact + ", Number: "
								+ contactNumber + ", Type: "
								+ contactNumberType);
					}
					phones.close();
				}
			}
		}
		cur.close();
	}
}