package de.test.camera;

import java.io.File;
import java.io.FileNotFoundException;

import android.app.Activity;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Environment;
import android.provider.MediaStore;
import android.util.Log;

public class main extends Activity {
	private final int requestCode = 1337;
	private String SD_CARD_TEMP_DIR;

	/** Called when the activity is first created. */
	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.main);
		String SD_CARD_TEMP_DIR = Environment.getExternalStorageDirectory()
				+ File.separator + "tmpPhoto.jpg";
		Intent takePictureFromCameraIntent = new Intent(
				MediaStore.ACTION_IMAGE_CAPTURE);
		takePictureFromCameraIntent.putExtra(
				android.provider.MediaStore.EXTRA_OUTPUT, Uri
						.fromFile(new File(SD_CARD_TEMP_DIR)));
		startActivityForResult(takePictureFromCameraIntent, requestCode);

	}

	public void onActivityResult(int requestCode, int resultCode, Intent data) {
		super.onActivityResult(requestCode, resultCode, data);

		if (requestCode == this.requestCode) {
			if (resultCode == Activity.RESULT_OK) {

				File f = new File(SD_CARD_TEMP_DIR);
				try {
					Uri capturedImage = Uri
							.parse(android.provider.MediaStore.Images.Media
									.insertImage(getContentResolver(), f
											.getAbsolutePath(), null, null));

					Log
							.d("test", "Selected image: "
									+ capturedImage.toString());

					f.delete();
				} catch (FileNotFoundException e) {
					e.printStackTrace();
				}
			} else {
				Log.d("test", "Result code was " + resultCode);
			}
		}
	}

}