//
//  BackgroundNotificationAppDelegate.m
//  BackgroundNotification
//
//  Created by Jonathan Diehl on 20.06.11.
//  Copyright 2011 RWTH. All rights reserved.
//

#import "BackgroundNotificationAppDelegate.h"

@implementation BackgroundNotificationAppDelegate


@synthesize window=_window;

- (BOOL)application:(UIApplication *)application didFinishLaunchingWithOptions:(NSDictionary *)launchOptions
{
	// Override point for customization after application launch.
	[self.window makeKeyAndVisible];
    return YES;
}

- (void)applicationWillResignActive:(UIApplication *)application
{
    // Clear out any old notification before scheduling a new one.
    if([[application scheduledLocalNotifications] count] > 0) [application cancelAllLocalNotifications];
	
    // Create a new notification.
    UILocalNotification* alarm = [[[UILocalNotification alloc] init] autorelease];
	alarm.fireDate = [NSDate dateWithTimeIntervalSinceNow:5.0];
	alarm.repeatInterval = 0;
	alarm.soundName = @"alarmsound.caf";
	alarm.alertBody = @"Time to wake up!";
	alarm.applicationIconBadgeNumber = 1;
	
	[application scheduleLocalNotification:alarm];
}

- (void)applicationWillEnterForeground:(UIApplication *)application;
{
	// reset the badge
	[application setApplicationIconBadgeNumber:0];
}

- (void)dealloc
{
	[_window release];
    [super dealloc];
}

@end
