//
//  BackgroundLocationAppDelegate.m
//  BackgroundLocation
//
//  Created by Jonathan Diehl on 20.06.11.
//  Copyright 2011 RWTH. All rights reserved.
//

#import "BackgroundLocationAppDelegate.h"

@implementation BackgroundLocationAppDelegate


@synthesize window=_window;

- (BOOL)application:(UIApplication *)application didFinishLaunchingWithOptions:(NSDictionary *)launchOptions
{
	// init the location manager
	manager = [[CLLocationManager alloc] init];
	manager.delegate = self;
	[manager startUpdatingLocation];

	// if you only need to respond to significant location changes replace startUpdatingLocation with the following line:
	// [manager startMonitoringSignificantLocationChanges];

	[self.window makeKeyAndVisible];
    return YES;
}

- (void)dealloc
{
	[manager release];
	[_window release];
    [super dealloc];
}


#pragma mark CLLocationManagerDelegate

// updated location
- (void)locationManager:(CLLocationManager *)manager didUpdateToLocation:(CLLocation *)newLocation fromLocation:(CLLocation *)oldLocation;
{
	NSLog(@"New Location: (%.8f, %.8f)", newLocation.coordinate.latitude, newLocation.coordinate.longitude);
}

@end
