//
//  RootViewController.m
//  CameraExample
//
//  Created by Jonathan Diehl on 20.06.11.
//  Copyright 2011 RWTH. All rights reserved.
//

#import "RootViewController.h"

@implementation RootViewController


#pragma mark Interface Actions

// item from the toolbar was selected
- (IBAction)barButtonItemSelected:(UIBarButtonItem *)item;
{
	// create the image picker
	UIImagePickerController *picker = [[UIImagePickerController alloc] init];
	picker.delegate = self;
	
	// configure the image picker according to the bar item that was selected
	switch(item.tag) {
		case 0:
			// photo
			picker.sourceType = UIImagePickerControllerSourceTypeCamera;
			break;
			
		case 1:
			// library
			picker.sourceType = UIImagePickerControllerSourceTypePhotoLibrary;
			break;
	}
	
	// show the image picker
	[self presentModalViewController:picker animated:YES];
	[picker release];
}


#pragma mark UIImagePickerControllerDelegate

// finished
- (void)imagePickerController:(UIImagePickerController *)picker didFinishPickingMediaWithInfo:(NSDictionary *)info;
{
	// retrieve the image from the info dictionary
    UIImage *image = [info valueForKey:UIImagePickerControllerOriginalImage];
	
	// update the image view
	imageView.image = image;
	
	// dismiss the image picker
	[self dismissModalViewControllerAnimated:YES];
}

// canceled
- (void)imagePickerControllerDidCancel:(UIImagePickerController *)picker;
{
	// dismiss the image picker
	[self dismissModalViewControllerAnimated:YES];
}


@end
