//
//  BackgroundTaskAppDelegate.m
//  BackgroundTask
//
//  Created by Jonathan Diehl on 20.06.11.
//  Copyright 2011 RWTH. All rights reserved.
//

#import "BackgroundTaskAppDelegate.h"

@implementation BackgroundTaskAppDelegate


@synthesize window=_window;

- (BOOL)application:(UIApplication *)application didFinishLaunchingWithOptions:(NSDictionary *)launchOptions
{
	// Override point for customization after application launch.
	[self.window makeKeyAndVisible];
    return YES;
}

- (void)applicationDidEnterBackground:(UIApplication *)application
{
	// request background task
	UIBackgroundTaskIdentifier taskId = [application beginBackgroundTaskWithExpirationHandler:^(void){
		NSLog(@"We expired!");
	}];
	
	// do nothing for a while...
	while(YES) {
		sleep(1);
		NSLog(@"background time remaining: %.2f", application.backgroundTimeRemaining);
	}
	
	// we are done
	[application endBackgroundTask:taskId];
}

- (void)dealloc
{
	[_window release];
    [super dealloc];
}

@end
