package de.test.gesturelistener;

import android.app.Activity;
import android.os.Bundle;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.GestureDetector.OnGestureListener;
import android.widget.TextView;

public class main extends Activity implements OnGestureListener {

	private TextView label;

	private GestureDetector gestureScanner;

	/** Called when the activity is first created. */
	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.main);
		label = (TextView) findViewById(R.id.label);

		gestureScanner = new GestureDetector(this);
	}

	@Override
	public boolean onTouchEvent(MotionEvent me) {
		return gestureScanner.onTouchEvent(me);
	}

	@Override
	public boolean onDown(MotionEvent arg0) {
		label.setText("onDown");
		return false;
	}

	@Override
	public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX,
			float velocityY) {
		label.setText("onFling\n" + velocityX + "\n" + velocityY);
		return false;
	}

	@Override
	public void onLongPress(MotionEvent e) {
		label.setText("onLongPress");
	}

	@Override
	public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX,
			float distanceY) {
		label.setText("onScroll\n" + distanceX + "\n" + distanceY);
		return false;
	}

	@Override
	public void onShowPress(MotionEvent e) {
		label.setText("onShowPress");
	}

	@Override
	public boolean onSingleTapUp(MotionEvent e) {
		label.setText("onSingleTapUp");
		return false;
	}
}