package de.test.customanimation;

import android.app.Activity;
import android.graphics.Matrix;
import android.os.Bundle;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.LinearInterpolator;
import android.view.animation.Transformation;
import android.widget.ImageView;
import android.widget.LinearLayout;

public class main extends Activity {
	/** Called when the activity is first created. */
	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.main);
	}

	public void start1(View view) {
		LinearLayout myAnimation = (LinearLayout) findViewById(R.id.linearlayout);
		myAnimation.startAnimation(new MyAnimation());
	}

	public void start2(View view) {
		ImageView myAnimation = (ImageView) findViewById(R.id.imageView1);
		myAnimation.startAnimation(new MyAnimation());
//		myAnimation.startAnimation(AnimationUtils.loadAnimation(this, R.anim.out));
	}

	public class MyAnimation extends Animation {

		@Override
		public void initialize(int width, int height, int parentWidth,
				int parentHeight) {
			super.initialize(width, height, parentWidth, parentHeight);
			setDuration(5000);
			setFillAfter(true);
			setInterpolator(new LinearInterpolator());
		}

		@Override
		protected void applyTransformation(float interpolatedTime,
				Transformation t) {
			final Matrix matrix = t.getMatrix();
			matrix.setScale(interpolatedTime, interpolatedTime);
			matrix.postRotate(360*interpolatedTime);
		}
	}
}