//
//  ReceiptsListViewController.m
//  Receipts
//
//  Created by Mohd Kamaluddin on 3/14/11.
//  Copyright 2011 __MyCompanyName__. All rights reserved.
//

#import "ReceiptsListViewController.h"
#import "AddReceiptViewController.h"
#import "ReceiptInfo.h"
#import "Receipt.h"

@implementation ReceiptsListViewController
@synthesize receipts;

- (void)addReceipt:(id)sender;
{
	// show the add receipt controller
	AddReceiptViewController *vc = [[AddReceiptViewController alloc] initWithNibName:@"AddReceiptViewController" bundle:nil];
	vc.delegate = self;
	
	UINavigationController *navController = [[UINavigationController alloc] initWithRootViewController:vc];
	[vc release];
	
	[self presentModalViewController:navController animated:YES];
	[navController release];
	
}

#pragma mark AddReceiptViewControllerDelegate

- (void)didCreateReceipt:(Receipt *)receipt;
{
	// add the receipt to our mutable array
	[self.receipts addObject:receipt];
	[self.tableView reloadData];
	
}

#pragma mark -
#pragma mark View lifecycle


- (void)viewDidLoad {
    [super viewDidLoad];

	UIBarButtonItem *addButton = [[UIBarButtonItem alloc] initWithBarButtonSystemItem:UIBarButtonSystemItemAdd target:self action:@selector(addReceipt:)];
	self.navigationItem.rightBarButtonItem = addButton;
	[addButton release];
 
	// Uncomment the following line to display an Edit button in the navigation bar for this view controller.
	self.navigationItem.leftBarButtonItem = self.editButtonItem;
 
	self.title = @"Receipts";
	
	
	
	
	// TODO: Add loading functionality from file here (NSKeyedUnarchiver)
	
	NSArray *documentDirectories = NSSearchPathForDirectoriesInDomains(NSDocumentDirectory,NSUserDomainMask,YES);
	NSString *documentDirectory = [documentDirectories objectAtIndex:0];
	// the file to load from
	// create the array

	self.receipts = [NSKeyedUnarchiver unarchiveObjectWithFile:[documentDirectory stringByAppendingPathComponent:@"Receipts"]];

	if (!self.receipts)
		self.receipts = [NSMutableArray arrayWithCapacity:10];
	
	
}



- (void)viewWillAppear:(BOOL)animated {
    [super viewWillAppear:animated];
	//refresh the tableview
	[self.tableView reloadData];
}

/*
- (void)viewDidAppear:(BOOL)animated {
    [super viewDidAppear:animated];
}
*/


- (void)saveToFile
{
	// The thing to save is the self.receipts array (which needs to be NSCoding compliant)
	NSArray *documentDirectories = NSSearchPathForDirectoriesInDomains(NSDocumentDirectory,NSUserDomainMask,YES);
	NSString *documentDirectory = [documentDirectories objectAtIndex:0];
	// the file to load from
	
	//self.receipts = [NSKeyedArchiver archiveRootObject:self.receipts toFile:<#(NSString *)path#>];
	[NSKeyedArchiver archiveRootObject:self.receipts toFile:[documentDirectory stringByAppendingPathComponent:@"Receipts"]];
}

- (void)viewWillDisappear:(BOOL)animated {
    [super viewWillDisappear:animated];
	[self saveToFile];

}

/*
- (void)viewDidDisappear:(BOOL)animated {
    [super viewDidDisappear:animated];
}
*/
/*
// Override to allow orientations other than the default portrait orientation.
- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation {
    // Return YES for supported orientations.
    return (interfaceOrientation == UIInterfaceOrientationPortrait);
}
*/


#pragma mark -
#pragma mark Table view data source

- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    // Return the number of sections.
    return 1;
}


- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    // Return the number of rows in the section.
	return [self.receipts count];
}


// Customize the appearance of table view cells.
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    
    static NSString *CellIdentifier = @"Cell";
    
    UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:CellIdentifier];
    if (cell == nil) {
        cell = [[[UITableViewCell alloc] initWithStyle:UITableViewCellStyleDefault reuseIdentifier:CellIdentifier] autorelease];
    }
    
    // Configure the cell...
	Receipt  *currentReceipt = [self.receipts objectAtIndex:indexPath.row];
	cell.textLabel.text = currentReceipt.name;
	cell.imageView.image = currentReceipt.image;
    return cell;
}



// Override to support conditional editing of the table view.
- (BOOL)tableView:(UITableView *)tableView canEditRowAtIndexPath:(NSIndexPath *)indexPath {
    // Return NO if you do not want the specified item to be editable.
    return YES;
}




// Override to support editing the table view.
- (void)tableView:(UITableView *)tableView commitEditingStyle:(UITableViewCellEditingStyle)editingStyle forRowAtIndexPath:(NSIndexPath *)indexPath {
    
    if (editingStyle == UITableViewCellEditingStyleDelete) {
        // Delete the row from the data source.
		[self.receipts removeObjectAtIndex:indexPath.row];
		[self saveToFile];
        [tableView deleteRowsAtIndexPaths:[NSArray arrayWithObject:indexPath] withRowAnimation:UITableViewRowAnimationFade];
    }   
    else if (editingStyle == UITableViewCellEditingStyleInsert) {
        // Create a new instance of the appropriate class, insert it into the array, and add a new row to the table view.
    }   
}




// Override to support rearranging the table view.
- (void)tableView:(UITableView *)tableView moveRowAtIndexPath:(NSIndexPath *)fromIndexPath toIndexPath:(NSIndexPath *)toIndexPath {
}




// Override to support conditional rearranging of the table view.
- (BOOL)tableView:(UITableView *)tableView canMoveRowAtIndexPath:(NSIndexPath *)indexPath {
    // Return NO if you do not want the item to be re-orderable.
    return YES;
}



#pragma mark -
#pragma mark Table view delegate

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath {
	// Navigation logic may go here. Create and push another view controller.
    ReceiptInfo *receiptPage = [[ReceiptInfo alloc] initWithNibName:@"ReceiptInfo" bundle:nil];
	receiptPage.receipts = self.receipts;
	receiptPage.theReceipt = [self.receipts objectAtIndex:indexPath.row];
	
    // Pass the selected object to the new view controller.
    [self.navigationController pushViewController:receiptPage animated:YES];
    [receiptPage release];
}


#pragma mark -
#pragma mark Memory management

- (void)didReceiveMemoryWarning {
    // Releases the view if it doesn't have a superview.
    [super didReceiveMemoryWarning];
    
    // Relinquish ownership any cached data, images, etc. that aren't in use.
}

- (void)viewDidUnload {
    // Relinquish ownership of anything that can be recreated in viewDidLoad or on demand.
    // For example: self.myOutlet = nil;
}


- (void)dealloc {
	self.receipts = nil;
    [super dealloc];
}


@end

