//
//  ReceiptInfo.m
//  Receipts
//
//  Created by Mohd Kamaluddin on 3/10/11.
//  Copyright 2011 __MyCompanyName__. All rights reserved.
//

#import "ReceiptInfo.h"
#import "FullImage.h"

@implementation ReceiptInfo
@synthesize scrollview, dateField, timeField, additionalInfoField, locationField, nameField;
@synthesize theReceipt, photoButton, receipts;
// The designated initializer.  Override if you create the controller programmatically and want to perform customization that is not appropriate for viewDidLoad.
/*
- (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil {
    self = [super initWithNibName:nibNameOrNil bundle:nibBundleOrNil];
    if (self) {
        // Custom initialization.
    }
    return self;
}
*/


// Implement viewDidLoad to do additional setup after loading the view, typically from a nib.
 - (void)viewDidLoad {
 
	 UIBarButtonItem *editButton = [[UIBarButtonItem alloc] initWithBarButtonSystemItem:UIBarButtonSystemItemEdit 
																				 target:self 
																				 action:@selector(editButtonPressed:)];
	 self.navigationItem.rightBarButtonItem = editButton;
	 [editButton release];
	 
	 self.scrollview.contentSize = CGSizeMake(320, 720);
	 self.scrollview.frame = CGRectMake(0, 0, 320, 416);
	 self.scrollview.delegate = self;
	 
	 [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(keyboardDidShow:) name:UIKeyboardDidShowNotification object:nil];	 
	 [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(keyboardDidHide:) name:UIKeyboardDidHideNotification object:nil];	 
	 [super viewDidLoad];
	 
	 additionalInfoField.text = theReceipt.additionalInfo;
	 self.locationField.text = theReceipt.location;
	 self.nameField.text = theReceipt.name;
	 

	 self.dateField.text = [[[theReceipt.dateAndTime description] componentsSeparatedByString:@" "] objectAtIndex:0];
	 self.timeField.text = [[[theReceipt.dateAndTime description] componentsSeparatedByString:@" "] objectAtIndex:1];
	 
	 [self.photoButton setImage:theReceipt.image forState:UIControlStateNormal];
	 [self.photoButton setImage:theReceipt.image forState:UIControlStateHighlighted];
}


/*
// Override to allow orientations other than the default portrait orientation.
- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation {
    // Return YES for supported orientations.
    return (interfaceOrientation == UIInterfaceOrientationPortrait);
}
*/

- (void)didReceiveMemoryWarning {
    // Releases the view if it doesn't have a superview.
    [super didReceiveMemoryWarning];
    
    // Release any cached data, images, etc. that aren't in use.
}

- (void)viewDidUnload {
    [super viewDidUnload];
	
	
	
    // Release any retained subviews of the main view.
    // e.g. self.myOutlet = nil;
}


- (void)dealloc {
	self.receipts = nil;
	self.nameField = nil;
	self.dateField = nil;
	self.locationField = nil;
	self.additionalInfoField = nil;
	self.scrollview = nil;
	self.photoButton = nil;
    [super dealloc];
}

#pragma mark UIImagePickerController delegate methods
- (void)imagePickerController:(UIImagePickerController *)picker didFinishPickingMediaWithInfo:(NSDictionary *)info
{
	//TODO: Get System date and time and add it to the receipt info and textfields
	

}


#pragma mark Keyboard notification callbacks
- (void)keyboardDidShow:(NSNotification *) notification
{
	if(keyboardVisible){
		NSLog(@"Keyboard is already visible. Ignoring notification.");
		return;
	}
	
	NSDictionary *info = [notification userInfo];
	NSValue *value = [info objectForKey:UIKeyboardFrameBeginUserInfoKey];
	CGSize keyboardSize = [value CGRectValue].size;
	
	offset = self.scrollview.contentOffset;
	CGPoint newOffset = CGPointMake(offset.x, keyboardSize.height);
	
	[self.scrollview setContentOffset:newOffset animated:YES];
	//CGRect viewFrame = self.scrollview.frame;
	//viewFrame.size.height -= keyboardSize.height;
	//self.scrollview.frame = viewFrame;
	
	keyboardVisible = YES;
	
}

-(void)keyboardDidHide:(NSNotification *)notification{

	if(!keyboardVisible){
		
		NSLog(@"Keyboard is already hidden. Ignoring notification.");
		return;
	}
	
	self.scrollview.frame = CGRectMake(0, 0, 320, 460);
	
	self.scrollview.contentOffset = offset;
	
	keyboardVisible = NO;
	
}
#pragma mark UITextField delegate methods

- (void)textFieldDidEndEditing:(UITextField *)additionalInfoTextField
{
	if (additionalInfoTextField == self.additionalInfoField)
	{
		self.theReceipt.additionalInfo = additionalInfoTextField.text;
	}
	else if (additionalInfoTextField == self.locationField)
	{
		self.theReceipt.location = additionalInfoTextField.text;
	}
	else if (additionalInfoTextField == self.nameField) {
		self.theReceipt.name = additionalInfoTextField.text;
	}
	[additionalInfoTextField resignFirstResponder];
}


- (BOOL)textFieldShouldReturn:(UITextField *)textField
{
	[textField resignFirstResponder];
	return YES;
}

#pragma mark EditButton Action
- (void)editButtonPressed:(id)sender;
{
	UIBarButtonItem *editButton = [[UIBarButtonItem alloc] initWithBarButtonSystemItem:UIBarButtonSystemItemDone 
																				target:self 
																				action:@selector(doneButtonPressed:)];
	self.navigationItem.rightBarButtonItem = editButton;
	[editButton release];
	NSLog(@"EditButton pressed ");
	self.nameField.enabled = YES;
	self.dateField.enabled = NO;
	self.timeField.enabled = NO;
	self.additionalInfoField.enabled = YES;
	self.locationField.enabled = YES;

	
}

- (void)doneButtonPressed:(id)sender;
{
	UIBarButtonItem *editButton = [[UIBarButtonItem alloc] initWithBarButtonSystemItem:UIBarButtonSystemItemEdit 
																				target:self 
																				action:@selector(editButtonPressed:)];
	self.navigationItem.rightBarButtonItem = editButton;
	[editButton release];
	NSLog(@"DoneButton pressed");
	
	self.nameField.enabled = NO;
	self.dateField.enabled = NO;
	self.timeField.enabled = NO;
	self.additionalInfoField.enabled = NO;
	self.locationField.enabled = NO;
	
	self.theReceipt.additionalInfo = self.additionalInfoField.text;
	self.theReceipt.location = self.locationField.text;

}
- (void)saveToFile
{
	// The thing to save is the self.receipts array (which needs to be NSCoding compliant)
	NSArray *documentDirectories = NSSearchPathForDirectoriesInDomains(NSDocumentDirectory,NSUserDomainMask,YES);
	NSString *documentDirectory = [documentDirectories objectAtIndex:0];
	// the file to load from
	
	//self.receipts = [NSKeyedArchiver archiveRootObject:self.receipts toFile:<#(NSString *)path#>];
	[NSKeyedArchiver archiveRootObject:self.receipts toFile:[documentDirectory stringByAppendingPathComponent:@"Receipts"]];
}


- (IBAction)showLocationInMap:(id)sender;
{
	//Save to file before leavong app
	[self saveToFile];
	
	if (![self.locationField.text isEqualToString:@""])
	{
		[[UIApplication sharedApplication] openURL:[NSURL URLWithString:[NSString stringWithFormat:@"http://maps.google.com/maps?q=%@&z=15", self.locationField.text]]];	
	}
}

- (IBAction)showFullImage:(id)sender;
{
	NSLog(@"Show full image");
	FullImage *imageView = [[FullImage alloc] init];
	imageView.imageToShow = self.theReceipt.image;
	[self.navigationController pushViewController:imageView animated:YES];
	[imageView release];
	
}


@end
