//
//  Receipt.m
//  Receipts
//
//  Created by Mohd Kamaluddin on 3/10/11.
//  Copyright 2011 __MyCompanyName__. All rights reserved.
//

#import "Receipt.h"


@implementation Receipt

@synthesize name, location, additionalInfo, dateAndTime, imageKey;

- (void)encodeWithCoder:(NSCoder *)encoder
{
	[encoder encodeObject:self.name forKey:@"Name"];
	[encoder encodeObject:self.imageKey forKey:@"ImagePath"];
	[encoder encodeObject:self.dateAndTime forKey:@"DateAndTime"];
	[encoder encodeObject:self.location forKey:@"Location"];
	[encoder encodeObject:self.additionalInfo forKey:@"AdditionalInfo"];
}


- (id)initWithCoder:(NSCoder *)decoder
{

	self = [super init];
	if (self != nil)
	{
		self.name = [decoder decodeObjectForKey:@"Name"];
		self.imageKey = [decoder decodeObjectForKey:@"ImagePath"];
		self.dateAndTime = [decoder decodeObjectForKey:@"DateAndTime"];
		self.location = [decoder decodeObjectForKey:@"Location"];
		self.additionalInfo = [decoder decodeObjectForKey:@"AdditionalInfo"];
	}
	return self;
}

- (UIImage *)image;
{
	if (!image)
	{
		NSLog(@"No image loaded yet, do it now for imageKey %@",self.imageKey);
		NSString *docDir = [NSSearchPathForDirectoriesInDomains(NSDocumentDirectory, NSUserDomainMask, YES) objectAtIndex:0];	
		// If you go to the folder below, you will find those pictures
		NSString *pngFilePath = [docDir	stringByAppendingPathComponent:[NSString stringWithFormat:@"%@.png",self.imageKey]];
		NSLog(@"Available Files");
		// Create file manager
		NSError *error;
		NSFileManager *fileMgr = [NSFileManager defaultManager];
		
		// Point to Document directory
		NSString *documentsDirectory = [NSHomeDirectory() stringByAppendingPathComponent:@"Documents"];
		
		// Write out the contents of home directory to console
		NSLog(@"Documents directory: %@", [fileMgr contentsOfDirectoryAtPath:documentsDirectory error:&error]);
		
		//NSData *data1 = [NSData dataWithContentsOfFile:pngFilePath];
		image = [[UIImage alloc] initWithContentsOfFile:pngFilePath];
		
	}
	else {
		NSLog(@"Image already loaded");
	}
	
	return image;
}

- (void)setImage:(UIImage *)theImage;
{
	// TODO: Write image to file with filename imageKey
	[self willChangeValueForKey:@"image"];
	if (!image){
		image = [theImage retain];
	}
	else {
		[theImage retain];
		[image release];
		image = theImage;
	}
	[self didChangeValueForKey:@"image"];
	
	NSString *docDir = [NSSearchPathForDirectoriesInDomains(NSDocumentDirectory, NSUserDomainMask, YES) objectAtIndex:0];	
	// If you go to the folder below, you will find those pictures
	NSString *pngFilePath = [docDir	stringByAppendingPathComponent:[NSString stringWithFormat:@"%@.png",self.imageKey]];
	NSLog(@"Saving image to file %@",pngFilePath);
	[UIImagePNGRepresentation(image) writeToFile:pngFilePath atomically:YES];
	
	//[NSString stringWithFormat:@"%@/images/%@.png",docDir,self.imageKey];
	//NSData *data1 = [NSData dataWithData:UIImagePNGRepresentation(theImage)];
	//[data1 writeToFile:pngFilePath atomically:YES];
}

@end
