//
//  AddReceiptViewController.m
//  Receipts
//
//  Created by Mohd Kamaluddin on 3/10/11.
//  Copyright 2011 __MyCompanyName__. All rights reserved.
//

#import "AddReceiptViewController.h"


@implementation AddReceiptViewController

@synthesize delegate, nameField, takePictureButton;

- (IBAction)takePicture:(id)sender;
{
	UIImagePickerController *photoController = [[UIImagePickerController alloc] init];
	photoController.delegate = self;
	[self presentModalViewController:photoController animated:YES];
}

- (IBAction)selectPicture:(id)sender;
{
	UIImagePickerController *photoController = [[UIImagePickerController alloc] init];
	photoController.sourceType = UIImagePickerControllerSourceTypePhotoLibrary;
	photoController.delegate = self;
	[self presentModalViewController:photoController animated:YES];	
}

- (void)done:(id)sender;
{
	[self dismissModalViewControllerAnimated:YES];
	[self.delegate didCreateReceipt:receipt];
}

- (void)cancel:(id)sender;
{
	[self dismissModalViewControllerAnimated:YES];
}


#pragma mark UITextFieldDelegate

- (void)textFieldDidEndEditing:(UITextField *)textField
{
	receipt.name = nameField.text;
}

- (BOOL)textFieldShouldReturn:(UITextField *)textField;
{
	[textField resignFirstResponder];
	return YES;
}

#pragma mark UIImagePickerControllerDelegate

- (void)imagePickerController:(UIImagePickerController *)picker didFinishPickingMediaWithInfo:(NSDictionary *)info
{
	// store the photo
	UIImage *theImage = [info objectForKey:UIImagePickerControllerOriginalImage];
	receipt.image = theImage;
	[self dismissModalViewControllerAnimated:YES];}

// The designated initializer.  Override if you create the controller programmatically and want to perform customization that is not appropriate for viewDidLoad.
/*
- (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil {
    self = [super initWithNibName:nibNameOrNil bundle:nibBundleOrNil];
    if (self) {
        // Custom initialization.
    }
    return self;
}
*/

// Implement viewDidLoad to do additional setup after loading the view, typically from a nib.
- (void)viewDidLoad {
    [super viewDidLoad];
	
	receipt = [[Receipt alloc] init];
	receipt.name = @"New Receipt";
	//Create a UUID for the new picture
	CFUUIDRef newUniqueID = CFUUIDCreate(kCFAllocatorDefault);
	CFStringRef newUniqueIDString = CFUUIDCreateString(kCFAllocatorDefault, newUniqueID);
	receipt.imageKey = (NSString *)newUniqueIDString;
	CFRelease(newUniqueIDString);
	CFRelease(newUniqueID);
	
	UIBarButtonItem *doneButton = [[UIBarButtonItem alloc] initWithBarButtonSystemItem:UIBarButtonSystemItemDone target:self action:@selector(done:)];
    self.navigationItem.rightBarButtonItem = doneButton;
	[doneButton release];
	
	UIBarButtonItem *cancelButton = [[UIBarButtonItem alloc] initWithBarButtonSystemItem:UIBarButtonSystemItemCancel target:self action:@selector(cancel:)];
    self.navigationItem.leftBarButtonItem = cancelButton;
	[cancelButton release];
	receipt.dateAndTime = [NSDate date];
	nameField.text = receipt.name;
	[nameField becomeFirstResponder];
	
	//Check if camera available
	if((![UIImagePickerController isSourceTypeAvailable:UIImagePickerControllerSourceTypeCamera]))
	{
	self.takePictureButton.hidden = YES;
	}
}

/*
// Override to allow orientations other than the default portrait orientation.
- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation {
    // Return YES for supported orientations.
    return (interfaceOrientation == UIInterfaceOrientationPortrait);
}
*/

- (void)didReceiveMemoryWarning {
    // Releases the view if it doesn't have a superview.
    [super didReceiveMemoryWarning];
    
    // Release any cached data, images, etc. that aren't in use.
}

- (void)viewDidUnload {
    [super viewDidUnload];
    // Release any retained subviews of the main view.
    // e.g. self.myOutlet = nil;
}


- (void)dealloc {
	self.takePictureButton = nil;
	[receipt release];
    [super dealloc];

}


@end
