//
//  Closet.m
//  Closet2
//
//  Created by Sarah Hawi on 3/10/11.
//  Copyright 2011 __MyCompanyName__. All rights reserved.
//

#import "Closet.h"
#import "Item.h"
#import "allOptionsInOne.h"
#import "ItemsList.h"
#import "Outfit.h"


@implementation Closet


#pragma mark -
#pragma mark View lifecycle


- (void)viewDidLoad {
    [super viewDidLoad];
	UIBarButtonItem *outfitButton = [[UIBarButtonItem alloc] initWithTitle:@"Outfit" style:UIBarButtonSystemItemDone  target:self action:@selector(outfitButtonClicked)];
	self.navigationItem.rightBarButtonItem = outfitButton;

	[outfitButton release];		
	

    // Uncomment the following line to display an Edit button in the navigation bar for this view controller.
    // self.navigationItem.rightBarButtonItem = self.editButtonItem;
}



- (void)viewWillAppear:(BOOL)animated {
    [super viewWillAppear:animated];
	[self.tableView reloadData];
}
-(void)outfitButtonClicked{
	Outfit *outfitView= [[Outfit alloc]init];
	NSMutableArray *outfitArray = [[NSMutableArray alloc] initWithCapacity:3];
	
	ItemsList *closetManager = [ItemsList sharedItemsList];
	NSMutableArray *theCloset = [[closetManager sharedCloset] retain];
	
	for (Item *anItem in theCloset)
	{
		if (anItem.chosen)
			[outfitArray addObject:anItem];
	}
	outfitView = [[Outfit alloc] initWithArray:outfitArray];
	[self.navigationController pushViewController:outfitView animated:YES];
	
	[theCloset release];
}

/*
- (void)viewDidAppear:(BOOL)animated {
    [super viewDidAppear:animated];
}
*/
/*
- (void)viewWillDisappear:(BOOL)animated {
    [super viewWillDisappear:animated];
}
*/
/*
- (void)viewDidDisappear:(BOOL)animated {
    [super viewDidDisappear:animated];
}
*/
/*
// Override to allow orientations other than the default portrait orientation.
- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation {
    // Return YES for supported orientations.
    return (interfaceOrientation == UIInterfaceOrientationPortrait);
}
*/
- (void)didSelectSomeThing:(id)option;
{
	//item.category = option;
//	NSArray *indexPaths = [NSArray arrayWithObject:[NSIndexPath indexPathForRow:0 inSection:0]];
//	[self.tableView reloadRowsAtIndexPaths:indexPaths withRowAnimation:UITableViewRowAnimationNone];
}


#pragma mark -
#pragma mark Table view data source

- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    // Return the number of sections.
    return 1;
}


- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    // Return the number of rows in the section.
    return 9;
}


// Customize the appearance of table view cells.
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    
    	static NSString *CellIdentifier = @"Cell";
    
    UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:CellIdentifier];
    if (cell == nil) {
        cell = [[[UITableViewCell alloc] initWithStyle:UITableViewCellStyleValue1 reuseIdentifier:CellIdentifier] autorelease];
    }
    
    // Configure the cell...
	switch(indexPath.row) {
		case 0: 
			// jackets
			cell.textLabel.text = @"Jackets";
			cell.accessoryType = UITableViewCellAccessoryDisclosureIndicator;
			break;
			
		case 1:
			// trousers
			cell.textLabel.text = @"Trousers";
		    cell.accessoryType = UITableViewCellAccessoryDisclosureIndicator;
			break;
			
		case 2:
			// tshirts
			cell.textLabel.text = @"T-Shirts";
		    cell.accessoryType = UITableViewCellAccessoryDisclosureIndicator;
			break;
			
		case 3:
			//shirts
			cell.textLabel.text = @"Shirts";
		    cell.accessoryType = UITableViewCellAccessoryDisclosureIndicator;
			break;
			
			
		case 4:
			// shorts
			cell.textLabel.text = @"Shorts";
		    cell.accessoryType = UITableViewCellAccessoryDisclosureIndicator;
			break;
			
		case 5:
			// shoes
			cell.textLabel.text = @"Shoes";
		    cell.accessoryType = UITableViewCellAccessoryDisclosureIndicator;
			break;
			
		case 6:
			// accessories
			cell.textLabel.text = @"Accessories";
			cell.accessoryType = UITableViewCellAccessoryDisclosureIndicator;
			break;
			
		case 7:
			// accessories
			cell.textLabel.text = @"Dress";
			cell.accessoryType = UITableViewCellAccessoryDisclosureIndicator;
			break;
			
		case 8:
			// accessories
			cell.textLabel.text = @"Skirt";
			cell.accessoryType = UITableViewCellAccessoryDisclosureIndicator;
			break;
		
			
			
			
		default:
			// undefined
			NSAssert(NO, @"invalid row: %d", indexPath.row);
			break;
			
	}
    return cell;
}


/*
// Override to support conditional editing of the table view.
- (BOOL)tableView:(UITableView *)tableView canEditRowAtIndexPath:(NSIndexPath *)indexPath {
    // Return NO if you do not want the specified item to be editable.
    return YES;
}
*/


/*
// Override to support editing the table view.
- (void)tableView:(UITableView *)tableView commitEditingStyle:(UITableViewCellEditingStyle)editingStyle forRowAtIndexPath:(NSIndexPath *)indexPath {
    
    if (editingStyle == UITableViewCellEditingStyleDelete) {
        // Delete the row from the data source.
        [tableView deleteRowsAtIndexPaths:[NSArray arrayWithObject:indexPath] withRowAnimation:UITableViewRowAnimationFade];
    }   
    else if (editingStyle == UITableViewCellEditingStyleInsert) {
        // Create a new instance of the appropriate class, insert it into the array, and add a new row to the table view.
    }   
}
*/


/*
// Override to support rearranging the table view.
- (void)tableView:(UITableView *)tableView moveRowAtIndexPath:(NSIndexPath *)fromIndexPath toIndexPath:(NSIndexPath *)toIndexPath {
}
*/


/*
// Override to support conditional rearranging of the table view.
- (BOOL)tableView:(UITableView *)tableView canMoveRowAtIndexPath:(NSIndexPath *)indexPath {
    // Return NO if you do not want the item to be re-orderable.
    return YES;
}
*/


#pragma mark -
#pragma mark Table view delegate

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath {
    //UIViewController *viewController = nil;
	allOptionsInOne *options = nil;
	
	ItemsList *closetManager = [ItemsList sharedItemsList];
	NSMutableArray *theCloset = [[closetManager sharedCloset] retain];
	
	NSMutableArray *jackets= [NSMutableArray arrayWithCapacity:10];
	NSMutableArray *trousers= [NSMutableArray arrayWithCapacity:10];
	NSMutableArray *skirts= [NSMutableArray arrayWithCapacity:10];
	NSMutableArray *shoes= [NSMutableArray arrayWithCapacity:10];
	NSMutableArray *dresses= [NSMutableArray arrayWithCapacity:10];
	NSMutableArray *acc= [NSMutableArray arrayWithCapacity:10];
	NSMutableArray *shirts= [NSMutableArray arrayWithCapacity:10];
	NSMutableArray *tShirts= [NSMutableArray arrayWithCapacity:10];
	NSMutableArray *shorts= [NSMutableArray arrayWithCapacity:10];
    //NSMutableArray *images= [NSMutableArray arrayWithCapacity:10];

//
	
	//NSArray *options;
	
	
	switch(indexPath.row) {
		case 0:
			for (Item *item in theCloset) 
			{
			if ([item.category isEqualToString:@"Jacket"]) {
				[jackets addObject:item];
			}	
			}
			options = [[allOptionsInOne alloc] initWithOptions:jackets];
			
			break;
			
		case 1:
			for (Item *item in theCloset) 
			{
				if ([item.category isEqualToString:@"Trousers"]) {
					[trousers addObject:item];
				}	
			}
			options = [[allOptionsInOne alloc] initWithOptions:trousers ];
			
						break;
			
		case 2:
			for (Item *item in theCloset) 
			{
				if ([item.category isEqualToString:@"T-Shirt"]) {
					[tShirts addObject:item];
				}	
			}
			options = [[allOptionsInOne alloc] initWithOptions:tShirts];
			
			break;
			
		case 3:
			for (Item *item in theCloset) 
			{
				if ([item.category isEqualToString:@"Shirt"]) {
					[shirts addObject:item];
				}	
			}
			options = [[allOptionsInOne alloc] initWithOptions:shirts ];
			
			break;	
		
			
		case 4:
			for (Item *item in theCloset) 
			{
				if ([item.category isEqualToString:@"Shorts"]) {
					[shorts addObject:item];
				}	
			}
			options = [[allOptionsInOne alloc] initWithOptions:shorts];
			
			break;
			
		case 5:
			for (Item *item in theCloset) 
			{
				if ([item.category isEqualToString:@"Shoes"]) {
					[shoes addObject:item];
				}	
			}
			options = [[allOptionsInOne alloc] initWithOptions:shoes];
			
			break;
			
		case 6:
			for (Item *item in theCloset) 
			{
				if ([item.category isEqualToString:@"Accessory"]) {
					[acc addObject:item];
				}	
			}
			options = [[allOptionsInOne alloc] initWithOptions:acc ];
			
			break;
		case 7:
			for (Item *item in theCloset) 
			{
				if ([item.category isEqualToString:@"Skirt" ]) {
					[skirts addObject:item];
				}	
			}
			options = [[allOptionsInOne alloc] initWithOptions:skirts];
			
						break;
			
		case 8:
			for (Item *item in theCloset) 
			{
				if ([item.category isEqualToString:@"Dress" ]) {
					[dresses addObject:item];
				}	
			}
			options = [[allOptionsInOne alloc] initWithOptions:dresses];
			
			break;
			
	}
	
	
	[self.navigationController pushViewController:options animated:YES];
	
	[options release];
//	[jackets release];
//	[shorts release];
//	[trousers release];
//	[dresses release];
//	[skirts release];
//	[shirts release];
//	[tShirts release];
//	[shoes release];
//	[acc release];
	

}


#pragma mark -
#pragma mark Memory management

- (void)didReceiveMemoryWarning {
    // Releases the view if it doesn't have a superview.
    [super didReceiveMemoryWarning];
    
    // Relinquish ownership any cached data, images, etc. that aren't in use.
}

- (void)viewDidUnload {
    // Relinquish ownership of anything that can be recreated in viewDidLoad or on demand.
    // For example: self.myOutlet = nil;
}


- (void)dealloc {
    [super dealloc];
}


@end

