//
//  PicDiscription.m
//  Closet2
//
//  Created by Sarah Hawi on 3/10/11.
//  Copyright 2011 __MyCompanyName__. All rights reserved.
//

#import "PicDiscription.h"
#import "Discriptions.h"
#import "SelectViewController.h"
#import "ItemsList.h"
#import "ImageCache.h"
#import "Item.h"
#import "Closet.h"

@interface PicDiscription ()
- (UITableViewCell *)descriptionCellForRow:(NSUInteger)row;
- (UITableViewCell *)takePictureCell;


- (void)didSelectDescriptionAtRow:(NSIndexPath *)indexPath;
- (void)didSelectTakePicture:(NSIndexPath *)indexPath;;
@end


@implementation PicDiscription

- (void)didSelectCategory:(id)option;
{
	item.category = option;
	NSArray *indexPaths = [NSArray arrayWithObject:[NSIndexPath indexPathForRow:0 inSection:0]];
	[self.tableView reloadRowsAtIndexPaths:indexPaths withRowAnimation:UITableViewRowAnimationNone];
}

- (void)didSelectColor:(id)option;
{
	item.colorr = option;
	NSArray *indexPaths = [NSArray arrayWithObject:[NSIndexPath indexPathForRow:2 inSection:0]];
	[self.tableView reloadRowsAtIndexPaths:indexPaths withRowAnimation:UITableViewRowAnimationNone];
}

- (void)didSelectWeather:(id)option;
{
	item.weather = option;
	NSArray *indexPaths = [NSArray arrayWithObject:[NSIndexPath indexPathForRow:1 inSection:0]];
	[self.tableView reloadRowsAtIndexPaths:indexPaths withRowAnimation:UITableViewRowAnimationNone];
}

- (void)didChangeAvailable:(UISwitch *)switchView;
{
	item.available = switchView.on;
}

- (void)didChangeFormal:(UISwitch *)switchView;
{
	item.formal = switchView.on;
}



#pragma mark -
#pragma mark View lifecycle

- (void)viewDidLoad {
    [super viewDidLoad];
	
	ItemsList *closetManager = [ItemsList sharedItemsList];
	theCloset = [[closetManager sharedCloset] retain];
	
	// Since we are in the addiewcontroller, create a new item
	item = [[Item alloc] init];
	//Create a UUID for the new picture
	CFUUIDRef newUniqueID = CFUUIDCreate(kCFAllocatorDefault);
	CFStringRef newUniqueIDString = CFUUIDCreateString(kCFAllocatorDefault, newUniqueID);
	item.imageKey = (NSString *)newUniqueIDString;
	CFRelease(newUniqueIDString);
	CFRelease(newUniqueID);
	
	
	// TODO: check when the done button is actually required
	//Add done-button
	UIBarButtonItem *doneButton = [[UIBarButtonItem alloc] initWithBarButtonSystemItem:UIBarButtonSystemItemDone target:self action:@selector(doneButtonClicked)];
								   self.navigationItem.rightBarButtonItem = doneButton;
								   [doneButton release];							   
								   
	
	
}
-(void)doneButtonClicked{


	[theCloset addObject:item];
	NSLog(@"Number of items in closet %d",[theCloset count]);
	[[ItemsList sharedItemsList] saveToFile];
//	Closet *closetView= [[Closet alloc]init];
	self.tabBarController.selectedIndex = 0;
	[item release];
	
	//NSIndexPath *indexPathForRow=0;
	//	indexPathForRow.cell.detailTextLabel.text = @"";
			
			
	
		item = [[Item alloc] init];
	// Since we are in the addiewcontroller, create a new item
	item = [[Item alloc] init];
	//Create a UUID for the new picture
	CFUUIDRef newUniqueID = CFUUIDCreate(kCFAllocatorDefault);
	CFStringRef newUniqueIDString = CFUUIDCreateString(kCFAllocatorDefault, newUniqueID);
	item.imageKey = (NSString *)newUniqueIDString;
	CFRelease(newUniqueIDString);
	CFRelease(newUniqueID);
	
//	[self.navigationController pushViewController:closetView animated:YES];
	
}


/*
- (void)viewDidLoad {
    [super viewDidLoad];

    // Uncomment the following line to display an Edit button in the navigation bar for this view controller.
    // self.navigationItem.rightBarButtonItem = self.editButtonItem;
}
*/

/*
- (void)viewWillAppear:(BOOL)animated {
    [super viewWillAppear:animated];
}
*/
/*
- (void)viewDidAppear:(BOOL)animated {
    [super viewDidAppear:animated];
}
*/
/*
- (void)viewWillDisappear:(BOOL)animated {
    [super viewWillDisappear:animated];
}
*/
/*
- (void)viewDidDisappear:(BOOL)animated {
    [super viewDidDisappear:animated];
}
*/
/*
// Override to allow orientations other than the default portrait orientation.
- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation {
    // Return YES for supported orientations.
    return (interfaceOrientation == UIInterfaceOrientationPortrait);
}
*/


#pragma mark private methods

- (UITableViewCell *)descriptionCellForRow:(NSUInteger)row;{
	
	

    static NSString *CellIdentifier = @"DescriptionCell";
    
    cell = [self.tableView dequeueReusableCellWithIdentifier:CellIdentifier];
    if (cell == nil) {
        cell = [[[UITableViewCell alloc] initWithStyle:UITableViewCellStyleValue1 reuseIdentifier:CellIdentifier] autorelease];
    }
    

	switch(row) {
		case 0: 
			// category
			cell.textLabel.text = @"Category:";
			cell.detailTextLabel.text = item.category;
			
		
			cell.accessoryType = UITableViewCellAccessoryDisclosureIndicator;
			break;
			
		case 1:
			// weather
			cell.textLabel.text = @"Weather:";
			cell.detailTextLabel.text = item.weather;
			
			cell.accessoryType = UITableViewCellAccessoryDisclosureIndicator;
			break;
			
		case 2:
			// weather
			cell.textLabel.text = @"Color:";
			cell.detailTextLabel.text = item.colorr;
			
			cell.accessoryType = UITableViewCellAccessoryDisclosureIndicator;
			break;
			
		case 3:
			// availability
			cell.textLabel.text = @"Available:";
			
			UISwitch *switchView1 = [[UISwitch alloc] initWithFrame:CGRectMake(200.5, 8.5, 94.0, 27.0)];
			[switchView1 addTarget:self action:@selector(didChangeAvailable:) forControlEvents:UIControlEventValueChanged];
			[cell.contentView addSubview:switchView1];
			[switchView1 release];
			
			break;
			
		case 4:
			// weather
			cell.textLabel.text = @"Formal:";
			UISwitch *switchView2 = [[UISwitch alloc] initWithFrame:CGRectMake(200.5, 8.5, 94.0, 27.0)];
			[switchView2 addTarget:self action:@selector(didChangeFormal:) forControlEvents:UIControlEventValueChanged];
			[cell.contentView addSubview:switchView2];
			[switchView2 release];
			
			
			break;
			
	}
	return cell;
}









- (UITableViewCell *)takePictureCell;
{
    static NSString *CellIdentifier = @"TakePictureCell";
    cell = [self.tableView dequeueReusableCellWithIdentifier:CellIdentifier];
    if (cell == nil) {
        cell = [[[UITableViewCell alloc] initWithStyle:UITableViewCellStyleDefault reuseIdentifier:CellIdentifier] autorelease];
    }
	
	cell.textLabel.text = @"Take Picture";
	
	return cell;
}


- (void)didSelectDescriptionAtRow:(NSIndexPath *)indexPath;
{
	UIViewController *viewController = nil;
	NSArray *options;
	
	
	switch(indexPath.row) {
		case 0:
			// category
			options = [NSArray arrayWithObjects:@"Jacket", @"Trousers", @"T-Shirt", @"Shirt", @"Shoes", @"Shorts", @"Accessory", @"Skirt",@"Dress",nil];
			viewController = [[SelectViewController alloc] initWithOptions:options target:self selector:@selector(didSelectCategory:)];
			break;
			
		case 1:
			// weather
			options = [NSArray arrayWithObjects:@"Sunny", @"Rain", @"Windy",@"Cold", nil];
			viewController = [[SelectViewController alloc] initWithOptions:options target:self selector:@selector(didSelectWeather:)];
						break;
			
		case 2:
			// weather
			options = [NSArray arrayWithObjects:@"Orange", @"Black", @"White",@"Brown",@"Red", @"Blue", @"Yellow",@"Green",@"Purple", @"Pink", @"Beige",@"Maroon",@"Other" ,nil];
			viewController = [[SelectViewController alloc] initWithOptions:options target:self selector:@selector(didSelectColor:)];
			break;
			
		case 3:
			// available
			break;
			
		case 4:
			// formal
			break;	
			
	}
	
	if(viewController) {
		[self.navigationController pushViewController:viewController animated:YES];
		[viewController release];
	} else {
		[self.tableView deselectRowAtIndexPath:indexPath animated:YES];
	}
	
}

- (void)didSelectTakePicture:(NSIndexPath *)indexPath;
{
	
	//Check if a camera is available, if not, take a photo from the library 
	UIImagePickerController *imagePicker = [[UIImagePickerController alloc] init];
	if ([UIImagePickerController isSourceTypeAvailable:UIImagePickerControllerSourceTypeCamera])
	{
		[imagePicker setSourceType:UIImagePickerControllerSourceTypeCamera];
	}
	else
	{
		[imagePicker setSourceType:UIImagePickerControllerSourceTypePhotoLibrary];
	}
	imagePicker.delegate = self;
	[self presentModalViewController:imagePicker animated:YES];
	
	
}




#pragma mark UIImagePickerControllerDelegate

- (void)imagePickerController:(UIImagePickerController *)picker didFinishPickingMediaWithInfo:(NSDictionary *)info
{

	// Set Image
	UIImage *theImage = [info objectForKey:UIImagePickerControllerOriginalImage];
	item.image = theImage;
	[self dismissModalViewControllerAnimated:YES];
}


#pragma mark -
#pragma mark Table view data source

- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    // Return the number of sections.
    return 2;
}


- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    // Return the number of rows in the section.
	switch(section) {
		case 0:
			return 5;
		case 1:
			return 1;
		
	}
	
	return 0;
}


// Customize the appearance of table view cells.
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    
	UITableViewCell *cell;
	
	switch(indexPath.section) {
		case 0:
			cell = [self descriptionCellForRow:indexPath.row];
			break;
			
		case 1:
			cell = [self takePictureCell];
			break;
		
	}
    return cell;
}


#pragma mark -
#pragma mark Table view delegate

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
	switch(indexPath.section) {
		case 0:
			[self didSelectDescriptionAtRow:indexPath];
			break;
			
		case 1:
			[self didSelectTakePicture:indexPath];
			break;
			}
}


#pragma mark -
#pragma mark Memory management

- (void)didReceiveMemoryWarning {
    // Releases the view if it doesn't have a superview.
    [super didReceiveMemoryWarning];
    
    // Relinquish ownership any cached data, images, etc. that aren't in use.
}

- (void)viewDidUnload {
    // Relinquish ownership of anything that can be recreated in viewDidLoad or on demand.
    // For example: self.myOutlet = nil;
}


- (void)dealloc {
	[theCloset release];
	[item release];

    [super dealloc];
}


@end

