//
//  ImageCache.m
//  Closet2
//
//  Created by Sarah Hawi on 3/15/11.
//  Copyright 2011 __MyCompanyName__. All rights reserved.
//

#import "ImageCache.h"

static ImageCache *sharedImageCache;

@implementation ImageCache

#pragma mark Singleton implementation 
+ (ImageCache *)sharedImageCache
{
	if (!sharedImageCache)
	{
		sharedImageCache = [[ImageCache alloc] init];
	}
	return sharedImageCache;
}

+ (id)allocWithZone:(NSZone *)zone
{
	if(!sharedImageCache) {
		sharedImageCache = [super allocWithZone:zone];
		return sharedImageCache;
	}
	else {
		return nil;
	}
}

+ (id)copyWithZone:(NSZone *)zone
{
	return self;
}

- (void)release
{
	//not to be release, singleton instance only
	//gets destroyed on application end
}

#pragma mark Object creation/distruction

- (id)init
{
	self = [super init];
	if (self != nil) {
		dictionary = [[NSMutableDictionary alloc] init];
	}
	return self;
}

- (void)dealloc
{
	[dictionary release];
	[super dealloc];
}

#pragma mark Accessing the cache

- (void)setImage:(UIImage *)i forKey:(NSString *)s
{
	[dictionary setObject:i forKey:s];
	//TODO: add 
}

- (UIImage *) imageForKey:(NSString *)s
{
	return [dictionary objectForKey:s];	
}

- (void)deleteImageForKey:(NSString *)s
{
	[dictionary removeObjectForKey:s];	
}

@end
