//
//  Categories.m
//  Closet2
//
//  Created by Sarah Hawi on 3/10/11.
//  Copyright 2011 __MyCompanyName__. All rights reserved.
//

#import "SelectViewController.h"


@implementation SelectViewController

// init
- (id)initWithOptions:(NSArray *)someOptions target:(id)aTarget selector:(SEL)aSelector;
{
	self = [super initWithStyle:UITableViewStylePlain];
	if (self != nil) {
		options = [someOptions retain];
		target = aTarget;
		targetSelector = aSelector;
	}
	return self;
}

#pragma mark -
#pragma mark Table view data source

- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    // Return the number of sections.
    return 1;
}


- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    // Return the number of rows in the section.
    return [options count];
}


// Customize the appearance of table view cells.
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    
    static NSString *CellIdentifier = @"Cell";
    
    UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:CellIdentifier];
    if (cell == nil) {
        cell = [[[UITableViewCell alloc] initWithStyle:UITableViewCellStyleDefault reuseIdentifier:CellIdentifier] autorelease];
    }
	
	// configure the cell
	cell.textLabel.text = [options objectAtIndex:indexPath.row];
			
    return cell;
}


#pragma mark -
#pragma mark Table view delegate

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
	
	// get the selected option
	id selectedOption = [options objectAtIndex:indexPath.row];
	
	// inform the delegate
	[target performSelector:targetSelector withObject:selectedOption];
	
	// dismiss ourselves
	[self.navigationController popViewControllerAnimated:YES];
	
}

- (void)dealloc {
	[options release];
    [super dealloc];
}


@end

