//
//  ItemsList.m
//  Closet2
//
//  Created by Sarah Hawi on 3/15/11.
//  Copyright 2011 __MyCompanyName__. All rights reserved.
//

#import "ItemsList.h"
#import "FileHelper.h"

static ItemsList *sharedItemsList;

@implementation ItemsList

#pragma mark Singleton implementation

+(ItemsList *)sharedItemsList
{
	
	if (!sharedItemsList) {
		sharedItemsList = [[super allocWithZone:NULL] init]; //[[ItemsList alloc] init];
	}
	return sharedItemsList;
}

+ (id)allocWithZone:(NSZone *)zone
{
    return [[self sharedItemsList] retain];
}

- (id)copyWithZone:(NSZone *)zone
{
    return self;
}

- (id)retain
{
    return self;
}

- (NSUInteger)retainCount
{
    return NSUIntegerMax;  //denotes an object that cannot be released
}

- (void)release
{
    //do nothing
}

- (id)autorelease
{
    return self;
}



#pragma mark Shared Closet

-(NSMutableArray *)sharedCloset
{
	if (!theItemsList) 
		theItemsList = [[NSMutableArray alloc] initWithCapacity:10];
	return theItemsList;
}

- (NSString *)possessionArrayPath;
{
	return pathInDocumentsDirectory(@"Items.data");
}

#pragma mark Object Lifecycle

- (id) init
{
	self = [super init];
	if (self != nil) {
		// Load or create the array here
		NSString *possessionPath = [self possessionArrayPath];
		NSLog(@"Loading from File");
		theItemsList = [NSKeyedUnarchiver unarchiveObjectWithFile:possessionPath];
		if (!theItemsList) 
			theItemsList = [[NSMutableArray alloc] initWithCapacity:10];
	}
	return self;
}


#pragma mark File management

- (void)saveToFile;
{
	// save to file
	
	NSString *possessionPath = [self possessionArrayPath];
	[NSKeyedArchiver archiveRootObject:theItemsList toFile:possessionPath];
}



@end
