/*
 * Decompiled with CFR 0.152.
 */
package edu.rwth.hci.codegestalt.wizard;

import edu.rwth.hci.codegestalt.wizard.CgtWizardFileCreationPage;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class CgtWizard
extends Wizard
implements INewWizard {
    private static final String DEFAULT_EXTENSION = ".cgt";
    private static int fileCount = 1;
    private CgtWizardFileCreationPage creationPage;
    private IStructuredSelection selection;
    private IWorkbench workbench;
    private boolean userPreference = false;
    private int userPreferenceMembers = 0;

    public int getUserPreferenceMembers() {
        return this.userPreferenceMembers;
    }

    public void setUserPreferenceMembers(int userPreferenceMembers) {
        this.userPreference = true;
        this.userPreferenceMembers = userPreferenceMembers;
    }

    public void resetUserPreferenceMembers() {
        this.userPreference = false;
        this.userPreferenceMembers = 0;
    }

    public CgtWizard() {
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle("New Code Gestalt Diagram");
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.selection = selection;
    }

    public void addPages() {
        this.creationPage = new CgtWizardFileCreationPage(this.selection, "diagram" + fileCount + DEFAULT_EXTENSION, this.userPreference, this.userPreferenceMembers);
        this.addPage((IWizardPage)this.creationPage);
    }

    public boolean performFinish() {
        IPath fullPath = this.creationPage.getContainerFullPath();
        final String containerName = fullPath != null ? fullPath.toString() : "";
        final String fileName = this.creationPage.getFileName().endsWith(DEFAULT_EXTENSION) ? this.creationPage.getFileName() : String.valueOf(this.creationPage.getFileName()) + DEFAULT_EXTENSION;
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        CgtWizard.this.doFinish(containerName, fileName, monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)realException.getMessage());
            return false;
        }
        ++fileCount;
        return true;
    }

    private void doFinish(String containerName, String fileName, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("Creating " + fileName, 2);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = root.findMember((IPath)new Path(containerName));
        if (!resource.exists() || !(resource instanceof IContainer)) {
            this.throwCoreException("Container \"" + containerName + "\" does not exist.");
        }
        IContainer container = (IContainer)resource;
        final IFile file = container.getFile((IPath)new Path(fileName));
        try {
            InputStream stream = this.creationPage.getInitialContents();
            if (file.exists()) {
                file.setContents(stream, true, true, monitor);
            } else {
                file.create(stream, true, monitor);
            }
            stream.close();
        }
        catch (IOException iOException) {}
        monitor.worked(1);
        monitor.setTaskName("Opening file for editing...");
        this.getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                }
                catch (PartInitException partInitException) {}
            }
        });
        monitor.worked(1);
    }

    private void throwCoreException(String message) throws CoreException {
        Status status = new Status(4, "edu.rwth_aachen.hci.codegestalt", 0, message, null);
        throw new CoreException((IStatus)status);
    }
}

