/*
 * Decompiled with CFR 0.152.
 */
package edu.rwth.hci.codegestalt.view.ui;

import edu.rwth.hci.codegestalt.Activator;
import edu.rwth.hci.codegestalt.controller.command.FontChangeCommand;
import edu.rwth.hci.codegestalt.view.ui.AbstractContextButtonFigure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ImageFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Shell;

public class FontButtonFigure
extends AbstractContextButtonFigure {
    private static final Image defaultIcon = Activator.getImageDescriptor("icons/FontDefault16.png").createImage();
    private static final Image hoverIcon = Activator.getImageDescriptor("icons/FontHover16.png").createImage();
    ImageFigure iconFigure = null;
    String fontName = null;

    public FontButtonFigure(CommandStack commandStack, FontChangeCommand fontCommand, String fontName) {
        super(commandStack, fontCommand);
        this.fontName = fontName;
        this.setSize(16, 16);
        this.setOutline(false);
        this.setFill(false);
        this.setLayoutManager((LayoutManager)new ToolbarLayout());
        this.iconFigure = new ImageFigure(defaultIcon);
        this.add((IFigure)this.iconFigure);
        this.iconFigure.setToolTip((IFigure)new Label("Change Tag Font"));
    }

    public String getFontName() {
        return this.fontName;
    }

    public void setColor(String fontName) {
        this.fontName = fontName;
    }

    @Override
    public void showDefaultGraphics() {
        this.iconFigure.setImage(defaultIcon);
    }

    @Override
    public void showHoverGraphics() {
        this.iconFigure.setImage(hoverIcon);
    }

    @Override
    public void mousePressed(MouseEvent me) {
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                FontDialog fontPalette = new FontDialog(new Shell(Display.getDefault()), 0);
                fontPalette.setFontList(Display.getDefault().getSystemFont().getFontData());
                fontPalette.setText("Choose a Font");
                FontData dialogFontData = fontPalette.open();
                if (dialogFontData != null) {
                    FontChangeCommand command = (FontChangeCommand)((FontChangeCommand)FontButtonFigure.this.getCommand()).clone();
                    command.setFontName(dialogFontData.getName());
                    FontButtonFigure.this.getCommandStack().execute((Command)command);
                }
            }
        });
    }
}

