/*
 * Decompiled with CFR 0.152.
 */
package edu.rwth.hci.codegestalt.view;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class TypeHeaderFigure
extends Figure {
    private static final Color HEADER_TEXT_COLOR = new Color((Device)Display.getDefault(), 25, 76, 127);
    private static Font BOLD_TEXT;
    private Label typeLabel;
    private Label packageLabel;

    public TypeHeaderFigure(String typeName, Image typeImage, String packageName) {
        Font systemFont = Display.getDefault().getSystemFont();
        FontData[] fontData = systemFont.getFontData();
        int i = 0;
        while (i < fontData.length) {
            fontData[i].setStyle(1);
            ++i;
        }
        BOLD_TEXT = new Font((Device)Display.getDefault(), fontData);
        ToolbarLayout layout = new ToolbarLayout();
        layout.setMinorAlignment(1);
        layout.setStretchMinorAxis(false);
        this.setLayoutManager((LayoutManager)layout);
        this.setBorder((Border)new MarginBorder(4, 3, 4, 3));
        this.typeLabel = new Label(typeName, typeImage);
        this.typeLabel.setForegroundColor(new Color((Device)Display.getDefault(), HEADER_TEXT_COLOR.getRed(), HEADER_TEXT_COLOR.getGreen(), HEADER_TEXT_COLOR.getBlue()));
        this.typeLabel.setFont(BOLD_TEXT);
        this.packageLabel = new Label(packageName, AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.jdt.ui", (String)"icons/full/obj16/package_obj.gif").createImage());
        this.packageLabel.setIconTextGap(this.packageLabel.getIconTextGap() + 6);
        this.add((IFigure)this.typeLabel);
        this.add((IFigure)this.packageLabel);
    }

    public Label getTypeLabel() {
        return this.typeLabel;
    }

    public void setTypeLabel(Label typeLabel) {
        this.typeLabel = typeLabel;
    }

    public Label getPackageLabel() {
        return this.packageLabel;
    }

    public void setPackageLabel(Label packageLabel) {
        this.packageLabel = packageLabel;
    }

    public void setAlpha(int alpha) {
        float negAlphaf = 1.0f - (float)alpha / 255.0f;
        Color oldColor = this.getTypeLabel().getForegroundColor();
        this.getTypeLabel().setForegroundColor(new Color((Device)Display.getDefault(), HEADER_TEXT_COLOR.getRed() + Math.round(negAlphaf * (float)(255 - HEADER_TEXT_COLOR.getRed())), HEADER_TEXT_COLOR.getGreen() + Math.round(negAlphaf * (float)(255 - HEADER_TEXT_COLOR.getGreen())), HEADER_TEXT_COLOR.getBlue() + Math.round(negAlphaf * (float)(255 - HEADER_TEXT_COLOR.getBlue()))));
        oldColor.dispose();
        oldColor = this.getPackageLabel().getForegroundColor();
        this.getPackageLabel().setForegroundColor(new Color((Device)Display.getDefault(), 255 - alpha, 255 - alpha, 255 - alpha));
        oldColor.dispose();
    }
}

