/*
 * Decompiled with CFR 0.152.
 */
package edu.rwth.hci.codegestalt.view;

import java.util.Iterator;
import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;

public class SingleRowFlowLayout
extends FlowLayout {
    protected WorkingData data = null;

    public SingleRowFlowLayout() {
    }

    public SingleRowFlowLayout(boolean isHorizontal) {
        super(isHorizontal);
    }

    protected void initRow() {
        this.data.rowX = 0;
        this.data.rowHeight = 0;
        this.data.rowWidth = 0;
        this.data.rowCount = 0;
    }

    protected void initVariables(IFigure parent) {
        this.data.row = new IFigure[parent.getChildren().size()];
        this.data.bounds = new Rectangle[this.data.row.length];
        this.data.maxWidth = 10000;
    }

    public void layout(IFigure parent) {
        this.data = new WorkingData();
        Rectangle relativeArea = parent.getClientArea();
        this.data.area = this.transposer.t(relativeArea);
        Iterator iterator = parent.getChildren().iterator();
        int wHint = -1;
        int hHint = -1;
        if (this.isHorizontal()) {
            wHint = parent.getClientArea().width;
        } else {
            hHint = parent.getClientArea().height;
        }
        this.initVariables(parent);
        this.initRow();
        int i = 0;
        while (iterator.hasNext()) {
            IFigure f = (IFigure)iterator.next();
            Dimension pref = this.transposer.t(this.getChildSize(f, wHint, hHint));
            Rectangle r = new Rectangle(0, 0, pref.width, pref.height);
            if (this.data.rowCount > 0 && this.data.rowWidth + pref.width > this.data.maxWidth) {
                this.layoutRow(parent);
            }
            r.x = this.data.rowX;
            r.y = this.data.rowY;
            int dx = r.width + this.getMinorSpacing();
            this.data.rowX += dx;
            this.data.rowWidth += dx;
            this.data.rowHeight = this.isHorizontal() ? parent.getClientArea().height : parent.getClientArea().width;
            this.data.row[this.data.rowCount] = f;
            this.data.bounds[this.data.rowCount] = r;
            ++this.data.rowCount;
            ++i;
        }
        if (this.data.rowCount != 0) {
            this.layoutRow(parent);
        }
        this.data = null;
    }

    protected void layoutRow(IFigure parent) {
        int majorAdjustment = 0;
        int minorAdjustment = 0;
        int correctMajorAlignment = this.majorAlignment;
        int correctMinorAlignment = this.minorAlignment;
        majorAdjustment = this.data.area.width - this.data.rowWidth + this.getMinorSpacing();
        switch (correctMajorAlignment) {
            case 1: {
                majorAdjustment = 0;
                break;
            }
            case 0: {
                majorAdjustment /= 2;
                break;
            }
        }
        int j = 0;
        while (j < this.data.rowCount) {
            if (this.fill) {
                this.data.bounds[j].height = this.data.rowHeight;
            } else {
                minorAdjustment = this.data.rowHeight - this.data.bounds[j].height;
                switch (correctMinorAlignment) {
                    case 1: {
                        minorAdjustment = 0;
                        break;
                    }
                    case 0: {
                        minorAdjustment /= 2;
                        break;
                    }
                }
                this.data.bounds[j].y += minorAdjustment;
            }
            this.data.bounds[j].x += majorAdjustment;
            this.setBoundsOfChild(parent, this.data.row[j], this.transposer.t(this.data.bounds[j]));
            ++j;
        }
        this.data.rowY += this.data.rowHeight;
        this.initRow();
    }

    protected class WorkingData {
        public int rowHeight;
        public int rowWidth;
        public int rowCount;
        public int rowX;
        public int rowY;
        public int maxWidth;
        public Rectangle[] bounds;
        public Rectangle area;
        public IFigure[] row;

        protected WorkingData() {
        }
    }
}

