/*
 * Decompiled with CFR 0.152.
 */
package edu.rwth.hci.codegestalt.view;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;

public class RoundedPolyline
extends PolylineConnection {
    private static final int stepLine = 6;
    private static final int stepLineMin = 4;
    private boolean isDefaultBranch = false;

    protected void outlineShape(Graphics g) {
        Point pt2;
        Point pt1;
        int dist;
        PointList originalPoints = this.getPoints();
        PointList newPoints = new PointList();
        newPoints.addPoint(originalPoints.getFirstPoint());
        int i = 1;
        while (i < originalPoints.size() - 1) {
            Point refPoint = originalPoints.getPoint(i);
            Point prevPoint = originalPoints.getPoint(i - 1);
            Point nextPoint = originalPoints.getPoint(i + 1);
            int lengPrevious = Math.max(Math.abs(refPoint.x - prevPoint.x), Math.abs(refPoint.y - prevPoint.y));
            int lengNext = Math.max(Math.abs(refPoint.x - nextPoint.x), Math.abs(refPoint.y - nextPoint.y));
            int r = Math.min(Math.min(lengPrevious / 2, lengNext / 2), 20);
            int dxPrev = r * this.sign(prevPoint.x - refPoint.x);
            int dyPrev = r * this.sign(prevPoint.y - refPoint.y);
            int dxNext = r * this.sign(nextPoint.x - refPoint.x);
            int dyNext = r * this.sign(nextPoint.y - refPoint.y);
            Point prevLineEnd = new Point(refPoint.x + dxPrev, refPoint.y + dyPrev);
            newPoints.addPoint(prevLineEnd);
            Point nextLineStart = new Point(refPoint.x + dxNext, refPoint.y + dyNext);
            if (r < 3) {
                g.drawLine(prevLineEnd, nextLineStart);
            } else {
                int arcCenterX = refPoint.x + dxNext + dxPrev;
                int arcCenterY = refPoint.y + dyNext + dyPrev;
                double step = Math.min(Math.max(Math.PI / (double)r, 0.08), 0.2);
                Point arcPoint = null;
                double rad = 0.0;
                while (rad <= 1.5707963267948966) {
                    Point newArcPoint = new Point(arcCenterX - (int)Math.round((double)r * Math.cos(rad)) * this.sign(dxNext + dxPrev), arcCenterY - (int)Math.round((double)r * Math.sin(rad)) * this.sign(dyNext + dyPrev));
                    if (arcPoint != null) {
                        g.drawLine(arcPoint, newArcPoint);
                    } else {
                        g.drawLine(newArcPoint, newArcPoint.getDistance(prevLineEnd) < newArcPoint.getDistance(nextLineStart) ? prevLineEnd : nextLineStart);
                    }
                    arcPoint = newArcPoint;
                    rad += step;
                }
                g.drawLine(arcPoint, arcPoint.getDistance(prevLineEnd) < arcPoint.getDistance(nextLineStart) ? prevLineEnd : nextLineStart);
            }
            newPoints.addPoint(nextLineStart);
            ++i;
        }
        newPoints.addPoint(originalPoints.getLastPoint());
        i = 0;
        while (i < newPoints.size()) {
            g.drawLine(newPoints.getPoint(i), newPoints.getPoint(i + 1));
            i += 2;
        }
        if (this.isDefaultBranch && newPoints.size() > 1 && (dist = (pt1 = newPoints.getPoint(0)).getDistance2(pt2 = newPoints.getPoint(1))) > 40) {
            int slashSize = dist > 100 ? 6 : 4;
            int dX = pt2.x - pt1.x;
            int dY = pt2.y - pt1.y;
            int offsetX1 = slashSize * (this.sign(dX) + this.sign(dY));
            int offsetY1 = slashSize * (this.sign(dY) - this.sign(dX));
            Point refPoint1 = new Point(pt1.x + offsetX1, pt1.y + offsetY1);
            int offsetX2 = slashSize * (3 * this.sign(dX) - this.sign(dY));
            int offsetY2 = slashSize * (3 * this.sign(dY) + this.sign(dX));
            Point refPoint2 = new Point(pt1.x + offsetX2, pt1.y + offsetY2);
            g.drawLine(refPoint1, refPoint2);
        }
    }

    public void setDefaultBranch(boolean value) {
        this.isDefaultBranch = value;
    }

    public Rectangle getBounds() {
        Rectangle rect = super.getBounds();
        rect.union(rect.x - 18, rect.y - 18);
        rect.union(rect.x + rect.width + 18, rect.y + rect.height + 18);
        return rect;
    }

    private int sign(int test) {
        if (test > 0) {
            return 1;
        }
        if (test < 0) {
            return -1;
        }
        return 0;
    }
}

