/*
 * Decompiled with CFR 0.152.
 */
package edu.rwth.hci.codegestalt.model;

import edu.rwth.hci.codegestalt.model.Positionable;
import edu.rwth.hci.codegestalt.model.Type;
import edu.rwth.hci.codegestalt.tools.TypeComparator;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.widgets.Display;

public class Tag
extends Positionable {
    private static final long serialVersionUID = 1L;
    public static final String TYPE_ADDED = "Tag.typeAdded";
    public static final String TYPE_REMOVED = "Tag.typeRemoved";
    public static final String UPDATED_WEIGHT_AND_POSITION = "Tag.updatedWeightAndPosition";
    public static final String LAYOUT_BOUNDS_PROPERTY = "Tag.layoutBoundsProperty";
    public static final String USER_BOUNDS_PROPERTY = "Tag.userBoundsProperty";
    public static final String PREFERRED_BOUNDS_PROPERTY = "Tag.preferredBoundsProperty";
    public static final String PINNED_PROPERTY = "Tag.pinned";
    public static final String FONT_NAME_PROPERTY = "Tag.fontName";
    public static final String TAG_OVERLAY_NOTIFICATION = "Tag.tagOverlayNotification";
    private String term = "";
    private double weight = 10.0;
    private double maximumWeight = 0.0;
    private Rectangle layoutBounds = new Rectangle();
    private Rectangle userBounds = new Rectangle();
    private Rectangle preferredBounds = new Rectangle();
    private Point preferredLocation = new Point();
    private boolean pinned = false;
    private SortedMap<Type, Double> typeMap = new TreeMap<Type, Double>(new TypeComparator());
    private String fontName = Display.getDefault().getSystemFont().getFontData()[0].getName();

    public void updateType(Type type) {
        if (type != null) {
            Double weight = (Double)type.getTags().getTagsSortedByTerms().get(this.getTerm());
            if (weight != null) {
                this.typeMap.remove(type);
                this.typeMap.put(type, weight);
            } else {
                this.removeType(type);
            }
            this.calculateWeightAndPosition();
        }
    }

    public void calculateWeightAndPosition() {
        double maxWeight = 0.0;
        double totalWeight = 0.0;
        double x = 0.0;
        double y = 0.0;
        for (Type type : this.typeMap.keySet()) {
            Double weight = (Double)type.getTags().getTagsSortedByTerms().get(this.term);
            if (weight != null) {
                x += ((double)type.getLocation().x + 0.5 * (double)type.getSize().width) * weight;
                y += ((double)type.getLocation().y + 0.5 * (double)type.getSize().height) * weight;
                totalWeight += weight.doubleValue();
                maxWeight = Math.max(maxWeight, weight);
                continue;
            }
            this.removeType(type);
        }
        this.setPreferredLocation(new Point((double)Math.round(x /= totalWeight), (double)Math.round(y /= totalWeight)));
        this.weight = totalWeight / (double)this.typeMap.size();
        this.maximumWeight = maxWeight;
        this.firePropertyChange(UPDATED_WEIGHT_AND_POSITION, null, null);
    }

    public String getTerm() {
        return this.term;
    }

    public void setTerm(String term) {
        this.term = term;
        this.calculateWeightAndPosition();
    }

    public double getWeight() {
        return this.weight;
    }

    public void addType(Type type) {
        if (type != null && !this.typeMap.containsKey(type) && type.getTags().getTagsSortedByTerms().containsKey(this.term)) {
            this.updateType(type);
            this.firePropertyChange(TYPE_ADDED, null, type);
        }
    }

    public void removeType(Type type) {
        if (type != null && this.typeMap.containsKey(type)) {
            this.typeMap.remove(type);
            this.firePropertyChange(TYPE_REMOVED, null, type);
        }
    }

    public SortedMap<Type, Double> getTypeWeightMap() {
        return this.typeMap;
    }

    public double getMaximumWeight() {
        return this.maximumWeight;
    }

    public double getNormalizedWeightForType(Type type) {
        if (this.getWeight() > 0.0) {
            return (Double)this.getTypeWeightMap().get(type) / this.getMaximumWeight();
        }
        return 0.0;
    }

    public Rectangle getLayoutBounds() {
        return this.layoutBounds.getCopy();
    }

    public void setLayoutBounds(Rectangle layoutBounds) {
        if (layoutBounds != null && !this.layoutBounds.equals((Object)layoutBounds)) {
            this.layoutBounds = layoutBounds;
            this.firePropertyChange(LAYOUT_BOUNDS_PROPERTY, null, layoutBounds);
        }
    }

    public Rectangle getUserBounds() {
        return this.userBounds.getCopy();
    }

    public void setUserBounds(Rectangle userBounds) {
        if (userBounds != null && !this.userBounds.equals((Object)userBounds)) {
            this.userBounds = userBounds;
            this.firePropertyChange(USER_BOUNDS_PROPERTY, null, userBounds);
        }
    }

    public Rectangle getPreferredBounds() {
        return this.preferredBounds.getCopy();
    }

    public void setPreferredBounds(Rectangle preferredBounds) {
        if (preferredBounds != null && !this.preferredBounds.equals((Object)preferredBounds)) {
            this.preferredBounds = preferredBounds;
            this.firePropertyChange(PREFERRED_BOUNDS_PROPERTY, null, preferredBounds);
        }
    }

    public Point getPreferredLocation() {
        return this.preferredLocation.getCopy();
    }

    private void setPreferredLocation(Point preferredLocation) {
        if (preferredLocation != null && !this.preferredLocation.equals((Object)preferredLocation)) {
            this.preferredLocation = preferredLocation;
        }
    }

    public void setPinned(boolean pinned) {
        if (this.pinned != pinned) {
            this.pinned = pinned;
            this.firePropertyChange(PINNED_PROPERTY, !pinned, pinned);
        }
    }

    public boolean isPinned() {
        return this.pinned;
    }

    public String getFontName() {
        return this.fontName;
    }

    public void setFontName(String fontName) {
        if (fontName != null && !this.fontName.equals(fontName)) {
            this.fontName = fontName;
            this.firePropertyChange(FONT_NAME_PROPERTY, null, this.fontName);
        }
    }

    public String toString() {
        return "(" + this.getTerm() + ", " + this.weight + ")";
    }

    @Override
    public void setBounds(Rectangle bounds) {
        this.layoutBounds = this.getBounds();
        super.setBounds(bounds);
    }

    @Override
    public void setLocation(Point location) {
        this.layoutBounds = this.getBounds();
        super.setLocation(location);
    }

    @Override
    public void setSize(Dimension size) {
        this.layoutBounds = this.getBounds();
        super.setSize(size);
    }

    @Override
    public void setCenter(Point point) {
        this.layoutBounds = this.getBounds();
        super.setCenter(point);
    }

    public void fireTagOverlay(boolean tagOverlay) {
        this.calculateWeightAndPosition();
        this.firePropertyChange(TAG_OVERLAY_NOTIFICATION, null, tagOverlay);
    }
}

