/*
 * Decompiled with CFR 0.152.
 */
package edu.rwth.hci.codegestalt.model;

import edu.rwth.hci.codegestalt.model.ModelNode;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

public abstract class Positionable
extends ModelNode {
    private static final long serialVersionUID = 1L;
    private static IPropertyDescriptor[] descriptors = new IPropertyDescriptor[]{new TextPropertyDescriptor((Object)"edu.rwth.hci.codegestalt.model.Positionable.x", "X"), new TextPropertyDescriptor((Object)"edu.rwth.hci.codegestalt.model.Positionable.y", "Y"), new TextPropertyDescriptor((Object)"edu.rwth.hci.codegestalt.model.Positionable.width", "Width"), new TextPropertyDescriptor((Object)"edu.rwth.hci.codegestalt.model.Positionable.height", "Height")};
    protected static final String X_PROPERTY = "edu.rwth.hci.codegestalt.model.Positionable.x";
    protected static final String Y_PROPERTY = "edu.rwth.hci.codegestalt.model.Positionable.y";
    protected static final String CENTER_PROPERTY = "edu.rwth.hci.codegestalt.model.Positionable.center";
    protected static final String WIDTH_PROPERTY = "edu.rwth.hci.codegestalt.model.Positionable.width";
    protected static final String HEIGHT_PROPERTY = "edu.rwth.hci.codegestalt.model.Positionable.height";
    public static final String BOUNDS_PROPERTY = "edu.rwth.hci.codegestalt.model.Positionable.bounds";
    private Rectangle bounds = new Rectangle(0, 0, 0, 0);

    static {
        int i = 0;
        while (i < descriptors.length) {
            ((PropertyDescriptor)descriptors[i]).setValidator(new ICellEditorValidator(){

                public String isValid(Object value) {
                    int intValue = -1;
                    try {
                        intValue = Integer.parseInt((String)value);
                    }
                    catch (NumberFormatException numberFormatException) {
                        return "Not a number";
                    }
                    return intValue >= 0 ? null : "Value must be >=  0";
                }
            });
            ++i;
        }
    }

    public Rectangle getBounds() {
        return this.bounds.getCopy();
    }

    public Point getLocation() {
        return this.bounds.getLocation().getCopy();
    }

    public Dimension getSize() {
        return this.bounds.getSize().getCopy();
    }

    public Point getCenter() {
        return this.bounds.getCenter().getCopy();
    }

    public void setBounds(Rectangle bounds) {
        if (bounds == null) {
            throw new IllegalArgumentException();
        }
        if (!this.bounds.equals((Object)bounds)) {
            this.setSize(bounds.getSize());
            this.setLocation(bounds.getLocation());
        }
    }

    public void setLocation(Point point) {
        if (point == null) {
            throw new IllegalArgumentException();
        }
        if (!this.bounds.getLocation().equals((Object)point)) {
            this.bounds.setLocation(point);
            this.firePropertyChange(BOUNDS_PROPERTY, null, this.bounds);
            this.firePropertyChange(X_PROPERTY, null, this.bounds.x);
            this.firePropertyChange(Y_PROPERTY, null, this.bounds.y);
            this.firePropertyChange(CENTER_PROPERTY, null, this.bounds.getCenter().getCopy());
        }
    }

    public void setSize(Dimension dimension) {
        if (dimension == null) {
            throw new IllegalArgumentException();
        }
        if (!this.bounds.getSize().equals((Object)dimension)) {
            this.bounds.setSize(dimension);
            this.firePropertyChange(BOUNDS_PROPERTY, null, this.bounds);
            this.firePropertyChange(WIDTH_PROPERTY, null, this.bounds.width);
            this.firePropertyChange(HEIGHT_PROPERTY, null, this.bounds.height);
            this.firePropertyChange(CENTER_PROPERTY, null, this.bounds.getCenter().getCopy());
        }
    }

    public void setCenter(Point point) {
        if (point == null) {
            throw new IllegalArgumentException();
        }
        if (!this.bounds.getCenter().equals((Object)point)) {
            this.bounds.setLocation(point.x - this.bounds.width / 2, point.y - this.bounds.height / 2);
        }
    }

    @Override
    public IPropertyDescriptor[] getPropertyDescriptors() {
        return descriptors;
    }

    @Override
    public Object getPropertyValue(Object propertyId) {
        if (X_PROPERTY.equals(propertyId)) {
            return Integer.toString(this.bounds.x);
        }
        if (Y_PROPERTY.equals(propertyId)) {
            return Integer.toString(this.bounds.y);
        }
        if (WIDTH_PROPERTY.equals(propertyId)) {
            return Integer.toString(this.bounds.width);
        }
        if (HEIGHT_PROPERTY.equals(propertyId)) {
            return Integer.toString(this.bounds.height);
        }
        return super.getPropertyValue(propertyId);
    }

    @Override
    public void setPropertyValue(Object propertyId, Object value) {
        if (X_PROPERTY.equals(propertyId)) {
            int x = Integer.parseInt((String)value);
            this.setLocation(new Point(x, this.bounds.y));
        } else if (Y_PROPERTY.equals(propertyId)) {
            int y = Integer.parseInt((String)value);
            this.setLocation(new Point(this.bounds.x, y));
        } else if (WIDTH_PROPERTY.equals(propertyId)) {
            int width = Integer.parseInt((String)value);
            this.setSize(new Dimension(width, this.bounds.height));
        } else if (HEIGHT_PROPERTY.equals(propertyId)) {
            int height = Integer.parseInt((String)value);
            this.setSize(new Dimension(this.bounds.width, height));
        } else {
            super.setPropertyValue(propertyId, value);
        }
    }
}

