/*
 * Decompiled with CFR 0.152.
 */
package edu.rwth.hci.codegestalt.model;

import edu.rwth.hci.codegestalt.model.IFadeable;
import edu.rwth.hci.codegestalt.model.Member;
import edu.rwth.hci.codegestalt.model.ModelNode;

public class CallRelation
extends ModelNode
implements IFadeable {
    private static final long serialVersionUID = 1L;
    public static final String ATTACHED_CALLER = "CallRelation.attachedCaller";
    public static final String DETACHED_CALLER = "CallRelation.detachedCaller";
    public static final String ATTACHED_CALLEE = "CallRelation.attachedCallee";
    public static final String DETACHED_CALLEE = "CallRelation.detachedCallee";
    public static final String CHANGED_CALLER = "CallRelation.changedCaller";
    public static final String CHANGED_CALLEE = "CallRelation.changedCallee";
    public static final String SET_TO_PERMANENT = "CallRelation.setToPermanent";
    public static final String SET_TO_PREVIEW = "CallRelation.setToPreview";
    public static final boolean PERMANENT = true;
    public static final boolean PREVIEW = false;
    private int alpha = 255;
    private Member caller = null;
    private Member callee = null;
    private boolean callerAttached = false;
    private boolean calleeAttached = false;
    private boolean permanent = false;

    public CallRelation(Member caller, Member callee) {
        this.setCaller(caller);
        this.setCallee(callee);
    }

    private boolean attachCaller() {
        if (this.caller.addOutgoingCall(this)) {
            this.callerAttached = true;
            this.firePropertyChange(ATTACHED_CALLER, null, this.caller);
            return true;
        }
        return false;
    }

    private boolean detachCaller() {
        if (this.caller.removeOutgoingCall(this)) {
            this.callerAttached = false;
            this.firePropertyChange(DETACHED_CALLER, null, this.caller);
            return true;
        }
        return false;
    }

    private boolean attachCallee() {
        if (this.callee.addIncomingCall(this)) {
            this.calleeAttached = true;
            this.firePropertyChange(ATTACHED_CALLEE, null, this.callee);
            return true;
        }
        return false;
    }

    private boolean detachCallee() {
        if (this.callee.removeIncomingCall(this)) {
            this.calleeAttached = false;
            this.firePropertyChange(DETACHED_CALLEE, null, this.callee);
            return true;
        }
        return false;
    }

    public boolean attach() {
        return this.isValid() && this.attachCaller() && this.attachCallee();
    }

    public boolean detach() {
        return this.isValid() && this.detachCaller() && this.detachCallee();
    }

    private boolean isValid() {
        return this.callee != null && this.caller != null && !this.isDangling();
    }

    private boolean isDangling() {
        return !this.callerAttached && this.calleeAttached || this.callerAttached && !this.calleeAttached;
    }

    public boolean isAttached() {
        return this.callerAttached && this.calleeAttached;
    }

    public Member getCaller() {
        return this.caller;
    }

    public void setCaller(Member caller) {
        if (!this.callerAttached && caller != null && caller != this.caller && caller.getJdtData().getElementType() == 9) {
            this.caller = caller;
            this.firePropertyChange(CHANGED_CALLER, null, this.caller);
        }
    }

    public Member getCallee() {
        return this.callee;
    }

    public void setCallee(Member callee) {
        if (!this.calleeAttached && callee != null && callee != this.callee && callee.getJdtData().getElementType() == 9) {
            this.callee = callee;
            this.firePropertyChange(CHANGED_CALLEE, null, this.callee);
        }
    }

    public void setPermanent(boolean permanent) {
        if (permanent != this.permanent) {
            this.permanent = permanent;
            if (this.permanent) {
                this.firePropertyChange(SET_TO_PERMANENT, null, null);
            } else {
                this.firePropertyChange(SET_TO_PREVIEW, null, null);
            }
        }
    }

    public boolean isPermanent() {
        return this.permanent;
    }

    public String toString() {
        return String.valueOf(this.getCaller() != null ? this.getCaller().toString() : "null") + " --> " + (this.getCallee() != null ? this.getCallee().toString() : "null");
    }

    public boolean equals(Object obj) {
        if (obj instanceof CallRelation) {
            CallRelation relation = (CallRelation)obj;
            return this.getCaller().equals(relation.getCaller()) && this.getCallee().equals(relation.getCallee());
        }
        return false;
    }

    @Override
    public void setAlpha(int alpha) {
        if (this.alpha != alpha) {
            this.alpha = alpha;
            this.firePropertyChange("IFadeable.alpha", null, this.alpha);
        }
    }

    @Override
    public int getAlpha() {
        return this.alpha;
    }
}

