/*
 * Decompiled with CFR 0.152.
 */
package edu.rwth.hci.codegestalt.editor.context;

import edu.rwth.hci.codegestalt.Activator;
import edu.rwth.hci.codegestalt.controller.command.NoteCreateCommand;
import edu.rwth.hci.codegestalt.editor.CgtEditor;
import edu.rwth.hci.codegestalt.model.CgtDiagram;
import edu.rwth.hci.codegestalt.model.Note;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPart;

public class NoteCreateAction
extends SelectionAction {
    public static final String ID = "edu.rwth.hci.codegestalt.editor.NoteCreateAction";
    public static final String TEXT = "Create Note";
    public static final String TOOLTIP = "Create a Note to Annotate the Diagram";
    public static final ImageDescriptor ICON = Activator.getImageDescriptor("icons/CreateNote16.png");

    public NoteCreateAction(CgtEditor part) {
        super((IWorkbenchPart)part);
        this.setId(ID);
        this.setText(TEXT);
        this.setToolTipText(TOOLTIP);
        this.setImageDescriptor(ICON);
    }

    public CgtEditor getCastedWorkbenchPart() {
        return (CgtEditor)this.getWorkbenchPart();
    }

    protected boolean calculateEnabled() {
        return true;
    }

    public void run() {
        Point mousePos = Display.getCurrent().getCursorLocation();
        mousePos = this.getCastedWorkbenchPart().getGraphicalViewer().getControl().toControl(mousePos);
        Note note = new Note();
        note.setText("Double click to edit");
        note.setBounds(new Rectangle(mousePos.x, mousePos.y, 150, 50));
        CgtDiagram diagram = this.getCastedWorkbenchPart().getModel();
        this.getCommandStack().execute((Command)new NoteCreateCommand(diagram, note));
    }
}

