/*
 * Decompiled with CFR 0.152.
 */
package edu.rwth.hci.codegestalt.controller.policy;

import edu.rwth.hci.codegestalt.controller.MemberEditPart;
import edu.rwth.hci.codegestalt.controller.TypeHeaderEditPart;
import edu.rwth.hci.codegestalt.controller.TypeTagCloudEditPart;
import edu.rwth.hci.codegestalt.controller.command.MemberMoveCommand;
import edu.rwth.hci.codegestalt.controller.command.TypeChildrenCreateCommand;
import edu.rwth.hci.codegestalt.controller.policy.MemberNonResizableEditPolicy;
import edu.rwth.hci.codegestalt.model.Member;
import edu.rwth.hci.codegestalt.model.Type;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.editpolicies.FlowLayoutEditPolicy;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.jface.viewers.StructuredSelection;

public class TypeFlowLayoutPolicy
extends FlowLayoutEditPolicy {
    protected Command createAddCommand(EditPart child, EditPart after) {
        return null;
    }

    protected Command createMoveChildCommand(EditPart child, EditPart after) {
        if (child != null && child instanceof MemberEditPart) {
            Member castedChild = ((MemberEditPart)child).getCastedModel();
            if (after instanceof TypeHeaderEditPart) {
                return new MemberMoveCommand(castedChild, this.getCastedModel(), this.getCastedModel().getFirstMember());
            }
            if (after instanceof MemberEditPart) {
                return new MemberMoveCommand(castedChild, this.getCastedModel(), ((MemberEditPart)after).getCastedModel());
            }
            if (after instanceof TypeTagCloudEditPart || after == null) {
                return new MemberMoveCommand(castedChild, this.getCastedModel(), null);
            }
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected Command getCreateCommand(CreateRequest request) {
        Object newChild = request.getNewObject();
        if (newChild != null && newChild instanceof StructuredSelection) {
            StructuredSelection selection = (StructuredSelection)newChild;
            EditPart after = this.getInsertionReference((Request)request);
            if (after instanceof TypeHeaderEditPart) {
                return new TypeChildrenCreateCommand(selection, this.getCastedModel(), this.getCastedModel().getFirstMember());
            }
            if (after instanceof MemberEditPart) {
                return new TypeChildrenCreateCommand(selection, this.getCastedModel(), (Member)after.getModel());
            }
            if (after instanceof TypeTagCloudEditPart || after == null) {
                return new TypeChildrenCreateCommand(selection, this.getCastedModel(), null);
            }
        }
        return UnexecutableCommand.INSTANCE;
    }

    private Type getCastedModel() {
        return (Type)this.getHost().getModel();
    }

    protected EditPolicy createChildEditPolicy(EditPart child) {
        if (child instanceof MemberEditPart) {
            return new MemberNonResizableEditPolicy();
        }
        return new NonResizableEditPolicy();
    }
}

