/*
 * Decompiled with CFR 0.152.
 */
package edu.rwth.hci.codegestalt.controller.policy;

import edu.rwth.hci.codegestalt.controller.NoteEditPart;
import edu.rwth.hci.codegestalt.controller.TagEditPart;
import edu.rwth.hci.codegestalt.controller.TypeEditPart;
import edu.rwth.hci.codegestalt.controller.command.DiagramChildrenCreateCommand;
import edu.rwth.hci.codegestalt.controller.command.NoteChangeConstraintCommand;
import edu.rwth.hci.codegestalt.controller.command.TagChangeConstraintCommand;
import edu.rwth.hci.codegestalt.controller.command.TypeChangeConstraintCommand;
import edu.rwth.hci.codegestalt.controller.policy.TypeResizableEditPolicy;
import edu.rwth.hci.codegestalt.model.CgtDiagram;
import edu.rwth.hci.codegestalt.model.Note;
import edu.rwth.hci.codegestalt.model.Tag;
import edu.rwth.hci.codegestalt.model.Type;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.editpolicies.XYLayoutEditPolicy;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.jface.viewers.StructuredSelection;

public class CgtXYLayoutEditPolicy
extends XYLayoutEditPolicy {
    protected Command createChangeConstraintCommand(EditPart child, Object constraint) {
        if (child != null && constraint != null && constraint instanceof Rectangle) {
            if (child instanceof TypeEditPart) {
                return new TypeChangeConstraintCommand((Type)child.getModel(), (Rectangle)constraint);
            }
            if (child instanceof TagEditPart) {
                Tag tag = ((TagEditPart)child).getCastedModel();
                if (tag.isPinned()) {
                    return new TagChangeConstraintCommand(tag, (Rectangle)constraint);
                }
            } else if (child instanceof NoteEditPart) {
                Note note = ((NoteEditPart)child).getCastedModel();
                return new NoteChangeConstraintCommand(note, (Rectangle)constraint);
            }
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected Command getCreateCommand(CreateRequest request) {
        StructuredSelection selection = (StructuredSelection)request.getNewObject();
        if (selection != null) {
            return new DiagramChildrenCreateCommand(selection, (CgtDiagram)this.getHost().getModel(), request.getLocation());
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected EditPolicy createChildEditPolicy(EditPart child) {
        if (child instanceof TypeEditPart) {
            return new TypeResizableEditPolicy();
        }
        if (child instanceof NoteEditPart) {
            return new TypeResizableEditPolicy();
        }
        return new NonResizableEditPolicy();
    }
}

