/*
 * Decompiled with CFR 0.152.
 */
package edu.rwth.hci.codegestalt.controller.factory;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaElementImageDescriptor;
import org.eclipse.jdt.ui.OverrideIndicatorLabelDecorator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class TypeIconFactory {
    private static final ImageDescriptor CLASS_DEFAULT_ICON = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.jdt.ui", (String)"icons/full/obj16/class_default_obj.gif");
    private static final ImageDescriptor CLASS_PRIVATE_ICON = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.jdt.ui", (String)"icons/full/obj16/innerclass_private_obj.gif");
    private static final ImageDescriptor CLASS_PROTECTED_ICON = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.jdt.ui", (String)"icons/full/obj16/innerclass_protected_obj.gif");
    private static final ImageDescriptor CLASS_PUBLIC_ICON = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.jdt.ui", (String)"icons/full/obj16/class_obj.gif");
    private static final ImageDescriptor INTERFACE_DEFAULT_ICON = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.jdt.ui", (String)"icons/full/obj16/int_default_obj.gif");
    private static final ImageDescriptor INTERFACE_PRIVATE_ICON = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.jdt.ui", (String)"icons/full/obj16/innerinterface_private_obj.gif");
    private static final ImageDescriptor INTERFACE_PROTECTED_ICON = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.jdt.ui", (String)"icons/full/obj16/innerinterface_protected_obj.gif");
    private static final ImageDescriptor INTERFACE_PUBLIC_ICON = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.jdt.ui", (String)"icons/full/obj16/int_obj.gif");
    private static final ImageDescriptor ANNOTATION_DEFAULT_ICON = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.jdt.ui", (String)"icons/full/obj16/annotation_default_obj.gif");
    private static final ImageDescriptor ANNOTATION_PRIVATE_ICON = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.jdt.ui", (String)"icons/full/obj16/annotation_private_obj.gif");
    private static final ImageDescriptor ANNOTATION_PROTECTED_ICON = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.jdt.ui", (String)"icons/full/obj16/annotation_protected_obj.gif");
    private static final ImageDescriptor ANNOTATION_PUBLIC_ICON = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.jdt.ui", (String)"icons/full/obj16/annotation_obj.gif");
    private static final ImageDescriptor ENUM_DEFAULT_ICON = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.jdt.ui", (String)"icons/full/obj16/enum_default_obj.gif");
    private static final ImageDescriptor ENUM_PRIVATE_ICON = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.jdt.ui", (String)"icons/full/obj16/enum_private_obj.gif");
    private static final ImageDescriptor ENUM_PROTECTED_ICON = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.jdt.ui", (String)"icons/full/obj16/enum_protected_obj.gif");
    private static final ImageDescriptor ENUM_PUBLIC_ICON = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.jdt.ui", (String)"icons/full/obj16/enum_obj.gif");
    private static final ImageDescriptor ERROR_ICON = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.jdt.ui", (String)"icons/full/obj16/error_obj.gif");
    private static OverrideIndicatorLabelDecorator OVERRIDE_DECORATOR = new OverrideIndicatorLabelDecorator();

    protected static int computeAdornmentFlags(IMember member) {
        int adornmentFlags = 0;
        try {
            int problem;
            int flags = member.getFlags();
            if (Flags.isAbstract((int)flags)) {
                adornmentFlags |= 1;
            }
            if (Flags.isFinal((int)flags)) {
                adornmentFlags |= 2;
            }
            if (Flags.isSynchronized((int)flags)) {
                adornmentFlags |= 4;
            }
            if (Flags.isStatic((int)flags)) {
                adornmentFlags |= 8;
            }
            if (TypeIconFactory.hasMain(member)) {
                adornmentFlags |= 0x10;
            }
            if ((problem = TypeIconFactory.computeProblems(member)) == 2) {
                adornmentFlags |= 0x40;
            } else if (problem == 1) {
                adornmentFlags |= 0x20;
            }
            adornmentFlags |= OVERRIDE_DECORATOR.computeAdornmentFlags((Object)member);
            if (member instanceof IMethod && ((IMethod)member).isConstructor()) {
                adornmentFlags |= 0x200;
            }
            if (Flags.isDeprecated((int)flags)) {
                adornmentFlags |= 0x400;
            }
            if (Flags.isVolatile((int)flags)) {
                adornmentFlags |= 0x800;
            }
            if (Flags.isTransient((int)flags)) {
                adornmentFlags |= 0x1000;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return adornmentFlags;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean hasMain(IMember member) {
        if (!(member instanceof IType)) return false;
        IType type = (IType)member;
        try {
            if (!type.isClass()) return false;
            IMethod[] iMethodArray = type.getMethods();
            int n = iMethodArray.length;
            int n2 = 0;
            while (true) {
                String[] params;
                if (n2 >= n) {
                    return false;
                }
                IMethod method = iMethodArray[n2];
                int flags = method.getFlags();
                if (Flags.isPublic((int)flags) && Flags.isStatic((int)flags) && method.getElementName().equals("main") && method.getReturnType().equals("V") && (params = method.getParameterTypes()).length == 1 && params[0].startsWith("[") && params[0].contains("String")) {
                    return true;
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        return false;
    }

    private static int computeProblems(IMember member) throws CoreException {
        IResource res = member.getResource();
        if (res == null || !res.isAccessible()) {
            return 0;
        }
        int severity = 0;
        IMarker[] markers = res.findMarkers("org.eclipse.core.resources.problemmarker", true, 1);
        if (markers != null && markers.length > 0) {
            int i = 0;
            while (i < markers.length && severity != 2) {
                int val;
                IMarker curr = markers[i];
                if (TypeIconFactory.isMarkerInRange(curr, (ISourceReference)member) && ((val = curr.getAttribute("severity", -1)) == 1 || val == 2)) {
                    severity = val;
                }
                ++i;
            }
        }
        return severity;
    }

    private static boolean isMarkerInRange(IMarker marker, ISourceReference sourceElement) throws CoreException {
        if (marker.isSubtypeOf("org.eclipse.core.resources.textmarker")) {
            int pos = marker.getAttribute("charStart", -1);
            return TypeIconFactory.isInside(pos, sourceElement);
        }
        return false;
    }

    protected static boolean isInside(int pos, ISourceReference sourceElement) throws CoreException {
        ISourceRange range = sourceElement.getSourceRange();
        if (range != null) {
            int rangeOffset = range.getOffset();
            return rangeOffset <= pos && rangeOffset + range.getLength() > pos;
        }
        return false;
    }

    public static Image getImageForType(IType type, Dimension size) {
        return new JavaElementImageDescriptor(TypeIconFactory.getBaseImageDescriptorForType(type), TypeIconFactory.computeAdornmentFlags((IMember)type), new Point(size.width, size.height)).createImage();
    }

    public static ImageDescriptor getBaseImageDescriptorForType(IType type) {
        try {
            int flags = type.getFlags();
            if (type.isClass()) {
                if (Flags.isPackageDefault((int)flags)) {
                    return CLASS_DEFAULT_ICON;
                }
                if (Flags.isPrivate((int)flags)) {
                    return CLASS_PRIVATE_ICON;
                }
                if (Flags.isProtected((int)flags)) {
                    return CLASS_PROTECTED_ICON;
                }
                return CLASS_PUBLIC_ICON;
            }
            if (type.isAnnotation()) {
                if (Flags.isPackageDefault((int)flags)) {
                    return ANNOTATION_DEFAULT_ICON;
                }
                if (Flags.isPrivate((int)flags)) {
                    return ANNOTATION_PRIVATE_ICON;
                }
                if (Flags.isProtected((int)flags)) {
                    return ANNOTATION_PROTECTED_ICON;
                }
                return ANNOTATION_PUBLIC_ICON;
            }
            if (type.isInterface()) {
                if (Flags.isPackageDefault((int)flags)) {
                    return INTERFACE_DEFAULT_ICON;
                }
                if (Flags.isPrivate((int)flags)) {
                    return INTERFACE_PRIVATE_ICON;
                }
                if (Flags.isProtected((int)flags)) {
                    return INTERFACE_PROTECTED_ICON;
                }
                return INTERFACE_PUBLIC_ICON;
            }
            if (type.isEnum()) {
                if (Flags.isPackageDefault((int)flags)) {
                    return ENUM_DEFAULT_ICON;
                }
                if (Flags.isPrivate((int)flags)) {
                    return ENUM_PRIVATE_ICON;
                }
                if (Flags.isProtected((int)flags)) {
                    return ENUM_PROTECTED_ICON;
                }
                return ENUM_PUBLIC_ICON;
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        return ERROR_ICON;
    }
}

