/*
 * Decompiled with CFR 0.152.
 */
package edu.rwth.hci.codegestalt.controller.command;

import edu.rwth.hci.codegestalt.model.CallRelation;
import edu.rwth.hci.codegestalt.model.CgtDiagram;
import edu.rwth.hci.codegestalt.model.InheritanceRelation;
import edu.rwth.hci.codegestalt.model.Member;
import edu.rwth.hci.codegestalt.model.Type;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.gef.commands.Command;

public class TypeDeleteCommand
extends Command {
    private Type child;
    private List<CallRelation> callRelations = new LinkedList<CallRelation>();
    private List<CallRelation> callRelationPreviews = new LinkedList<CallRelation>();
    private List<InheritanceRelation> inheritanceRelations = new LinkedList<InheritanceRelation>();
    private List<InheritanceRelation> inheritanceRelationPreviews = new LinkedList<InheritanceRelation>();
    private CgtDiagram parent;

    public TypeDeleteCommand(CgtDiagram parent, Type child) {
        this.child = child;
        this.parent = parent;
        this.setLabel("Delete Type");
        this.setDebugLabel("Delete " + (child != null ? child : "null from " + (parent != null ? parent : "null")));
    }

    public boolean canExecute() {
        return this.parent != null && this.child != null;
    }

    public void execute() {
        for (Member member : this.child.getMembers()) {
            for (CallRelation call : member.getIncomingCalls().values()) {
                if (call.isPermanent()) {
                    this.callRelations.add(call);
                    continue;
                }
                this.callRelationPreviews.add(call);
            }
            for (CallRelation call : member.getOutgoingCalls().values()) {
                if (call.isPermanent()) {
                    this.callRelations.add(call);
                    continue;
                }
                this.callRelationPreviews.add(call);
            }
        }
        for (InheritanceRelation inheritance : this.child.getIncomingInheritances().values()) {
            if (inheritance.isPermanent()) {
                this.inheritanceRelations.add(inheritance);
                continue;
            }
            this.inheritanceRelationPreviews.add(inheritance);
        }
        for (InheritanceRelation inheritance : this.child.getOutgoingInheritances().values()) {
            if (inheritance.isPermanent()) {
                this.inheritanceRelations.add(inheritance);
                continue;
            }
            this.inheritanceRelationPreviews.add(inheritance);
        }
        this.redo();
    }

    public void redo() {
        if (this.parent.removeChild(this.child)) {
            for (CallRelation call : this.callRelations) {
                call.detach();
            }
            for (InheritanceRelation inheritance : this.inheritanceRelations) {
                inheritance.detach();
            }
            for (CallRelation call : this.callRelationPreviews) {
                call.detach();
            }
            for (InheritanceRelation inheritance : this.inheritanceRelationPreviews) {
                inheritance.detach();
            }
            this.callRelationPreviews.clear();
            this.inheritanceRelationPreviews.clear();
        }
    }

    public void undo() {
        if (this.parent.addChild(this.child)) {
            for (CallRelation call : this.callRelations) {
                call.attach();
            }
            for (InheritanceRelation inheritance : this.inheritanceRelations) {
                inheritance.attach();
            }
        }
    }
}

