/*
 * Decompiled with CFR 0.152.
 */
package edu.rwth.hci.codegestalt.controller.command;

import edu.rwth.hci.codegestalt.model.CgtDiagram;
import edu.rwth.hci.codegestalt.model.Type;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.commands.Command;

public class TypeCreateCommand
extends Command {
    private Type child;
    private CgtDiagram parent;
    Rectangle bounds;

    public TypeCreateCommand(Type child, CgtDiagram parent, Rectangle bounds) {
        this.child = child;
        this.parent = parent;
        this.bounds = bounds;
        this.setLabel("Create Type");
        this.setDebugLabel("Create " + (child != null ? child : "null") + " in " + (parent != null ? parent : "null") + " with bounds " + (bounds != null ? bounds : "null"));
    }

    public boolean canExecute() {
        return this.parent != null && this.child != null && this.bounds != null;
    }

    public void execute() {
        this.child.setLocation(this.bounds.getLocation());
        this.child.getSize().width = Math.max(this.child.getSize().width, this.bounds.getSize().width);
        this.child.getSize().height = Math.max(this.child.getSize().height, this.bounds.getSize().height);
        this.redo();
    }

    public void redo() {
        this.parent.addChild(this.child);
    }

    public void undo() {
        this.parent.removeChild(this.child);
    }
}

