/*
 * Decompiled with CFR 0.152.
 */
package edu.rwth.hci.codegestalt.controller.command;

import edu.rwth.hci.codegestalt.model.Member;
import edu.rwth.hci.codegestalt.model.Type;
import java.util.TreeMap;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.gef.commands.Command;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.viewers.StructuredSelection;

public class TypeChildrenCreateCommand
extends Command {
    private StructuredSelection selection = null;
    private Type parent = null;
    private Member after = null;
    private boolean selectionParsed = false;
    private TreeMap<String, Member> newChildren = new TreeMap();
    private Dimension originalSize;

    public TypeChildrenCreateCommand(StructuredSelection selection, Type parent, Member after) {
        this.selection = selection;
        this.parent = parent;
        this.after = after;
        this.setLabel("Drag and Drop Member Creation");
        this.setDebugLabel("Drag and Drop Member Creation " + (selection != null ? selection : "null") + " in " + (parent != null ? parent : "null") + " right in front of  " + (after != null ? after : "null"));
    }

    public boolean canExecute() {
        this.parseSelection();
        return this.parent != null && this.newChildren.size() > 0 && (this.after == null || this.parent.getMembers().contains(this.after));
    }

    public void execute() {
        this.originalSize = this.parent.getSize();
        this.redo();
    }

    public void redo() {
        for (Member child : this.newChildren.values()) {
            this.parent.addMember(child, this.after);
        }
        this.parent.setSize(new Dimension(Math.max(this.originalSize.width, this.parent.predictSize().width), Math.max(this.originalSize.height, this.parent.predictSize().height)));
    }

    public void undo() {
        for (Member child : this.newChildren.values()) {
            this.parent.removeMember(child);
        }
        this.parent.setSize(this.originalSize);
    }

    private void parseSelection() {
        if (!this.selectionParsed) {
            for (Object object : this.selection.toList()) {
                if (!(object instanceof IJavaElement)) continue;
                IJavaElement element = (IJavaElement)object;
                if (element.getElementType() == 8) {
                    this.parseMember((IMember)element);
                    continue;
                }
                if (element.getElementType() != 9) continue;
                this.parseMember((IMember)element);
            }
            this.selectionParsed = true;
        }
    }

    private void parseMember(IMember member) {
        IMember memberParent = member;
        while (!(memberParent instanceof IType)) {
            if ((memberParent = memberParent.getParent()) != null) continue;
            return;
        }
        IType type = (IType)memberParent;
        if (type.equals(this.parent.getJdtData())) {
            Member newChildMember = new Member();
            newChildMember.setHandleIdentifier(member.getHandleIdentifier());
            this.newChildren.put(member.getHandleIdentifier(), newChildMember);
        }
    }
}

