/*
 * Decompiled with CFR 0.152.
 */
package edu.rwth.hci.codegestalt.controller.command;

import edu.rwth.hci.codegestalt.model.Type;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.commands.Command;

public class TypeChangeConstraintCommand
extends Command {
    private Rectangle newConstraint;
    private Rectangle originalConstraint;
    private Type child;

    public TypeChangeConstraintCommand(Type child, Rectangle newConstraint) {
        this.child = child;
        this.newConstraint = newConstraint;
        this.setLabel("Move/Resize Type");
        this.setDebugLabel("Move/Resize " + (child != null ? child : "null") + " to " + (newConstraint != null ? newConstraint : "null"));
    }

    public boolean canExecute() {
        return this.child != null && this.newConstraint != null;
    }

    public void execute() {
        this.originalConstraint = new Rectangle(this.child.getLocation(), this.child.getSize());
        this.redo();
    }

    public void redo() {
        this.child.setLocation(this.newConstraint.getLocation());
        this.child.setSize(this.newConstraint.getSize());
    }

    public void undo() {
        this.child.setLocation(this.originalConstraint.getLocation());
        this.child.setSize(this.originalConstraint.getSize());
    }
}

