/*
 * Decompiled with CFR 0.152.
 */
package edu.rwth.hci.codegestalt.controller.command;

import edu.rwth.hci.codegestalt.model.Member;
import edu.rwth.hci.codegestalt.model.Type;
import edu.rwth.hci.codegestalt.tools.StringComparator;
import java.util.TreeMap;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.gef.commands.Command;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;

public class TypeAddMembersCommand
extends Command {
    private static final int INVALID = 0;
    public static final int PUBLIC_MEMBERS = 1;
    public static final int PUBLIC_DEFAULT_AND_PROTECTED_MEMBERS = 2;
    public static final int ALL_MEMBERS = 3;
    public static final int PUBLIC_METHODS = 4;
    public static final int PUBLIC_DEFAULT_AND_PROTECTED_METHODS = 5;
    public static final int ALL_METHODS = 6;
    private Type parent = null;
    private int option = 0;
    private boolean selectionParsed = false;
    private TreeMap<String, Member> newChildren = new TreeMap(new StringComparator());
    private Dimension originalSize;
    private TreeMap<String, Member> originalChildren = new TreeMap(new StringComparator());

    public TypeAddMembersCommand(Type parent, int option) {
        this.parent = parent;
        this.option = option;
        this.setLabel("Member Creation");
        this.setDebugLabel("Member Creation with option" + option + " in " + (parent != null ? parent : "null"));
    }

    public Object clone() {
        return new TypeAddMembersCommand(this.parent, this.option);
    }

    public boolean canExecute() {
        this.parseJdtMembers();
        return this.parent != null && this.option > 0 && this.option <= 6 && this.newChildren.size() > 0;
    }

    public void execute() {
        this.originalSize = this.parent.getSize();
        for (Member member : this.parent.getMembers()) {
            this.originalChildren.put(member.getHandleIdentifier(), member);
        }
        this.redo();
    }

    public void redo() {
        for (Member child : this.newChildren.values()) {
            this.parent.addMember(child, null);
        }
        this.parent.setSize(new Dimension(Math.max(this.originalSize.width, this.parent.predictSize().width), Math.max(this.originalSize.height, this.parent.predictSize().height)));
    }

    public void undo() {
        for (Member child : this.newChildren.values()) {
            this.parent.removeMember(child);
        }
        this.parent.setSize(this.originalSize);
    }

    private void parseJdtMembers() {
        if (!this.selectionParsed) {
            try {
                IJavaElement[] iJavaElementArray = this.parent.getJdtData().getChildren();
                int n = iJavaElementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IJavaElement element = iJavaElementArray[n2];
                    if (element instanceof IMember) {
                        boolean isPublicDefaultOrProtected;
                        int flags;
                        boolean isPublic;
                        boolean isMethod;
                        IMember member = (IMember)element;
                        if (this.option == 3) {
                            this.parseMember(member);
                        }
                        boolean bl = isMethod = member.getElementType() == 9;
                        if (isMethod && this.option == 6) {
                            this.parseMember(member);
                        }
                        if ((isPublic = Flags.isPublic((int)(flags = member.getFlags()))) && this.option == 1) {
                            this.parseMember(member);
                        }
                        if (isPublic && isMethod && this.option == 4) {
                            this.parseMember(member);
                        }
                        boolean bl2 = isPublicDefaultOrProtected = Flags.isProtected((int)flags) || Flags.isPackageDefault((int)flags) || isPublic;
                        if (isPublicDefaultOrProtected && this.option == 2) {
                            this.parseMember(member);
                        }
                        if (isPublicDefaultOrProtected && isMethod && this.option == 5) {
                            this.parseMember(member);
                        }
                    }
                    ++n2;
                }
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
            this.selectionParsed = true;
        }
    }

    private void parseMember(IMember member) {
        IMember memberParent = member;
        while (!(memberParent instanceof IType)) {
            if ((memberParent = memberParent.getParent()) != null) continue;
            return;
        }
        IType type = (IType)memberParent;
        if (type.equals(this.parent.getJdtData())) {
            Member newChildMember = new Member();
            newChildMember.setHandleIdentifier(member.getHandleIdentifier());
            if (!this.originalChildren.containsKey(member.getHandleIdentifier())) {
                this.newChildren.put(member.getHandleIdentifier(), newChildMember);
            }
        }
    }
}

