/*
 * Decompiled with CFR 0.152.
 */
package edu.rwth.hci.codegestalt.controller.command;

import edu.rwth.hci.codegestalt.model.CgtDiagram;
import edu.rwth.hci.codegestalt.model.Tag;
import edu.rwth.hci.codegestalt.model.TagRegion;
import org.eclipse.gef.commands.Command;

public class TagUnpinCommand
extends Command {
    private Tag child;
    private CgtDiagram parent;
    private TagRegion region;

    public TagUnpinCommand(CgtDiagram parent, Tag child) {
        this.child = child;
        this.parent = parent;
        this.setLabel("Pin Tag");
        this.setDebugLabel("Pin " + (child != null ? child : "null from " + (parent != null ? parent : "null")));
    }

    public boolean canExecute() {
        this.region = this.parent.findTagRegionForTag(this.child);
        return this.parent != null && this.child != null && this.region != null;
    }

    public void execute() {
        this.redo();
    }

    public void redo() {
        this.parent.pinTag(this.child, false);
        this.child.setPinned(this.parent.isPinned(this.child));
        this.parent.removeChild(this.region);
    }

    public void undo() {
        this.parent.pinTag(this.child, true);
        this.child.setPinned(this.parent.isPinned(this.child));
        this.parent.addChild(this.region);
    }
}

