/*
 * Decompiled with CFR 0.152.
 */
package edu.rwth.hci.codegestalt.controller.command;

import edu.rwth.hci.codegestalt.controller.command.FontChangeCommand;
import edu.rwth.hci.codegestalt.model.Tag;

public class TagFontChangeCommand
extends FontChangeCommand {
    private Tag tag = null;
    private String originalFontName = null;

    public TagFontChangeCommand(Tag tag) {
        this.tag = tag;
        this.setLabel("Change font of " + (tag != null ? tag.toString() : "null"));
        this.setDebugLabel("Change font of " + (tag != null ? tag.toString() : "null"));
    }

    public boolean canExecute() {
        return this.tag != null && this.getFontName() != null;
    }

    public void execute() {
        this.originalFontName = this.tag.getFontName();
        this.redo();
    }

    public void redo() {
        this.tag.setFontName(this.getFontName());
    }

    public void undo() {
        this.tag.setFontName(this.originalFontName);
    }

    @Override
    public Object clone() {
        TagFontChangeCommand result = new TagFontChangeCommand(this.tag);
        result.setFontName(this.getFontName());
        return result;
    }
}

