/*
 * Decompiled with CFR 0.152.
 */
package edu.rwth.hci.codegestalt.controller.command;

import edu.rwth.hci.codegestalt.model.Note;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.commands.Command;

public class NoteChangeConstraintCommand
extends Command {
    private Rectangle newConstraint;
    private Rectangle originalConstraint;
    private Note child;

    public NoteChangeConstraintCommand(Note child, Rectangle newConstraint) {
        this.child = child;
        this.newConstraint = newConstraint;
        this.newConstraint.width = Math.max(32, this.newConstraint.width);
        this.setLabel("Move/Resize Note");
        this.setDebugLabel("Move/Resize " + (child != null ? child : "null") + " to " + (newConstraint != null ? newConstraint : "null"));
    }

    public boolean canExecute() {
        return this.child != null && this.newConstraint != null;
    }

    public void execute() {
        this.originalConstraint = this.child.getBounds().getCopy();
        this.redo();
    }

    public void redo() {
        this.child.setBounds(this.newConstraint);
    }

    public void undo() {
        this.child.setBounds(this.originalConstraint);
    }
}

