/*
 * Decompiled with CFR 0.152.
 */
package edu.rwth.hci.codegestalt.controller.command;

import edu.rwth.hci.codegestalt.model.Member;
import edu.rwth.hci.codegestalt.model.Type;
import org.eclipse.gef.commands.Command;

public class MemberMoveCommand
extends Command {
    private Member child;
    private Type parent;
    private int index;
    private int indexOriginal;

    public MemberMoveCommand(Member child, Type parent, Member after) {
        this.child = child;
        this.parent = parent;
        this.index = after != null && this.parent.getMembers().contains(after) ? Math.max(parent.getMembers().indexOf(after) - 1, 0) : (after != null ? -1 : parent.getMembers().size());
        this.setLabel("Move Member");
        this.setDebugLabel("Move " + (child != null ? child : "null") + " in " + (parent != null ? parent : "null") + " after " + (after != null ? after : "null"));
    }

    public boolean canExecute() {
        return this.parent != null && this.child != null && this.parent.getMembers().contains(this.child) && this.index >= 0;
    }

    public void execute() {
        this.indexOriginal = this.parent.getMembers().indexOf(this.child);
        this.redo();
    }

    public void redo() {
        this.parent.moveMember(this.child, this.index);
    }

    public void undo() {
        this.parent.moveMember(this.child, this.indexOriginal);
    }
}

