/*
 * Decompiled with CFR 0.152.
 */
package edu.rwth.hci.codegestalt.controller;

import edu.rwth.hci.codegestalt.controller.AbstractCgtGraphicalEditPart;
import edu.rwth.hci.codegestalt.controller.CgtDiagramEditPart;
import edu.rwth.hci.codegestalt.controller.ContextDeletable;
import edu.rwth.hci.codegestalt.controller.command.TypeAddMembersCommand;
import edu.rwth.hci.codegestalt.controller.command.TypeDeleteCommand;
import edu.rwth.hci.codegestalt.controller.command.TypeRemoveMembersCommand;
import edu.rwth.hci.codegestalt.controller.policy.TypeComponentEditPolicy;
import edu.rwth.hci.codegestalt.controller.policy.TypeFlowLayoutPolicy;
import edu.rwth.hci.codegestalt.controller.policy.TypeSelectionEditPolicy;
import edu.rwth.hci.codegestalt.model.InheritanceRelation;
import edu.rwth.hci.codegestalt.model.Member;
import edu.rwth.hci.codegestalt.model.ModelNode;
import edu.rwth.hci.codegestalt.model.Type;
import edu.rwth.hci.codegestalt.model.TypeTagCloud;
import edu.rwth.hci.codegestalt.view.TypeFigure;
import edu.rwth.hci.codegestalt.view.ui.BottomConnectionAnchor;
import edu.rwth.hci.codegestalt.view.ui.CloseButtonFigure;
import edu.rwth.hci.codegestalt.view.ui.CollapseAllButtonFigure;
import edu.rwth.hci.codegestalt.view.ui.ExpandAllButtonFigure;
import edu.rwth.hci.codegestalt.view.ui.InheritanceRelationAnchorButtonFigure;
import edu.rwth.hci.codegestalt.view.ui.TopConnectionAnchor;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;

public class TypeEditPart
extends AbstractCgtGraphicalEditPart
implements NodeEditPart,
ContextDeletable {
    private CloseButtonFigure closeButton = null;
    private ExpandAllButtonFigure expandButton = null;
    private CollapseAllButtonFigure collapseButton = null;
    private InheritanceRelationAnchorButtonFigure incomingInheritanceAnchorButton = null;
    private InheritanceRelationAnchorButtonFigure outgoingInheritanceAnchorButton = null;
    private ConnectionAnchor incomingAnchor = null;
    private ConnectionAnchor outgoingAnchor = null;

    @Override
    public CloseButtonFigure getCloseButton() {
        return this.closeButton;
    }

    @Override
    public void updateCloseButtonPosition() {
        if (this.isActive()) {
            Point pos = this.getCastedModel().getLocation();
            pos.x += this.getCastedModel().getSize().width - 16;
            this.getCloseButton().setLocation(pos);
        }
    }

    public ExpandAllButtonFigure getExpandButton() {
        return this.expandButton;
    }

    public void updateExpandButtonPosition() {
        if (this.isActive()) {
            Point pos = this.getCastedModel().getLocation();
            pos.x += this.getCastedModel().getSize().width - 32;
            pos.y += 16;
            this.getExpandButton().setLocation(pos);
        }
    }

    public CollapseAllButtonFigure getCollapseButton() {
        return this.collapseButton;
    }

    public void updateCollapseButtonPosition() {
        if (this.isActive()) {
            Point pos = this.getCastedModel().getLocation();
            pos.x += this.getCastedModel().getSize().width - 16;
            pos.y += 16;
            this.getCollapseButton().setLocation(pos);
        }
    }

    public InheritanceRelationAnchorButtonFigure getIncomingInheritancesAnchorButton() {
        return this.incomingInheritanceAnchorButton;
    }

    public InheritanceRelationAnchorButtonFigure getOutgoingInheritancesAnchorButton() {
        return this.outgoingInheritanceAnchorButton;
    }

    public void updateAnchorButtonPositions() {
        if (this.isActive()) {
            Point pos = this.getCastedModel().getLocation();
            pos.y -= this.getIncomingInheritancesAnchorButton().getSize().height / 2;
            pos.x += (this.getCastedModel().getSize().width - this.getIncomingInheritancesAnchorButton().getSize().width) / 2;
            this.getOutgoingInheritancesAnchorButton().setLocation(pos.getCopy());
            pos.y += this.getCastedModel().getSize().height;
            this.getIncomingInheritancesAnchorButton().setLocation(pos.getCopy());
        }
    }

    private void updateBackgroundPosition() {
        this.getCastedModel().getBackground().setBounds(this.getCastedModel().getBounds());
    }

    private ConnectionAnchor getIncomingAnchor() {
        if (this.incomingAnchor == null) {
            this.incomingAnchor = new BottomConnectionAnchor(this.getFigure());
        }
        return this.incomingAnchor;
    }

    private ConnectionAnchor getOutgoingAnchor() {
        if (this.outgoingAnchor == null) {
            this.outgoingAnchor = new TopConnectionAnchor(this.getFigure());
        }
        return this.outgoingAnchor;
    }

    public Type getCastedModel() {
        return (Type)this.getModel();
    }

    private TypeFigure getCastedView() {
        return (TypeFigure)this.getFigure();
    }

    private void openTypeInEditor() throws PartInitException, JavaModelException {
        ICompilationUnit cu = this.getCastedModel().getJdtData().getCompilationUnit();
        IEditorPart javaEditor = JavaUI.openInEditor((IJavaElement)cu);
        JavaUI.revealInEditor((IEditorPart)javaEditor, (IJavaElement)this.getCastedModel().getJdtData());
    }

    private void setViewAlpha(int alpha) {
        this.getCastedModel().getBackground().setAlpha(alpha);
        this.getCastedView().setAlpha(alpha);
        this.getCastedModel().getHeader().setAlpha(alpha);
        this.getCastedModel().getTags().setAlpha(alpha);
        for (Member member : this.getCastedModel().getMembers()) {
            member.setAlpha(alpha);
        }
        this.getCloseButton().setAlpha(alpha);
        this.getIncomingInheritancesAnchorButton().setAlpha(alpha);
        this.getOutgoingInheritancesAnchorButton().setAlpha(alpha);
        ((TypeSelectionEditPolicy)this.getEditPolicy("Selection Feedback")).tagOverlayChanged(alpha != 255);
    }

    public void activate() {
        if (!this.isActive()) {
            super.activate();
            this.getCastedModel().addPropertyChangeListener(this);
            this.getCastedModel().getTags().addPropertyChangeListener(this);
            CommandStack commandStack = this.getRoot().getViewer().getEditDomain().getCommandStack();
            this.closeButton = new CloseButtonFigure(commandStack, new TypeDeleteCommand(((CgtDiagramEditPart)this.getParent()).getCastedModel(), this.getCastedModel()));
            this.expandButton = new ExpandAllButtonFigure(commandStack, new TypeAddMembersCommand(this.getCastedModel(), 3));
            this.collapseButton = new CollapseAllButtonFigure(commandStack, new TypeRemoveMembersCommand(this.getCastedModel(), 3));
            this.incomingInheritanceAnchorButton = new InheritanceRelationAnchorButtonFigure(commandStack, null);
            this.outgoingInheritanceAnchorButton = new InheritanceRelationAnchorButtonFigure(commandStack, null);
            this.updateBackgroundPosition();
        }
    }

    public void deactivate() {
        if (this.isActive()) {
            super.deactivate();
            ((ModelNode)this.getModel()).removePropertyChangeListener(this);
        }
    }

    protected IFigure createFigure() {
        TypeFigure result = new TypeFigure(this.getCastedModel().getShortName(), this.getCastedModel().getPackageName());
        return result;
    }

    protected void createEditPolicies() {
        this.installEditPolicy("Selection Feedback", (EditPolicy)new TypeSelectionEditPolicy());
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new TypeComponentEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new TypeFlowLayoutPolicy());
    }

    protected List getModelChildren() {
        return this.getCastedModel().getChildren();
    }

    protected List<InheritanceRelation> getModelSourceConnections() {
        return new ArrayList<InheritanceRelation>(this.getCastedModel().getOutgoingInheritances().values());
    }

    protected List<InheritanceRelation> getModelTargetConnections() {
        return new ArrayList<InheritanceRelation>(this.getCastedModel().getIncomingInheritances().values());
    }

    public void performRequest(Request request) {
        if (request.getType() == "open") {
            try {
                this.openTypeInEditor();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propertyId = evt.getPropertyName();
        if ("edu.rwth.hci.codegestalt.model.Positionable.bounds".equals(propertyId)) {
            this.refreshVisuals();
        }
        if ("Type.childAdded".equals(propertyId) || "Type.childRemoved".equals(propertyId)) {
            this.refreshChildren();
        }
        if ("Type.incomingInheritanceAdded".equals(propertyId) || "Type.incomingInheritanceRemoved".equals(propertyId)) {
            this.refreshTargetConnections();
        }
        if ("Type.outgoingInheritanceAdded".equals(propertyId) || "Type.outgoingInheritanceRemoved".equals(propertyId)) {
            this.refreshSourceConnections();
        }
        if ("IFadeable.alpha".equals(propertyId)) {
            this.setViewAlpha((Integer)evt.getNewValue());
        }
        if (propertyId.equals(TypeTagCloud.TERM_MAP_PROPERTY)) {
            this.getCastedModel().setTags((TypeTagCloud)evt.getSource());
        }
    }

    protected void refreshVisuals() {
        this.updateBackgroundPosition();
        Rectangle bounds = new Rectangle(this.getCastedModel().getLocation(), this.getCastedModel().getSize());
        ((GraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, this.getFigure(), (Object)bounds);
        this.updateCloseButtonPosition();
        this.updateExpandButtonPosition();
        this.updateCollapseButtonPosition();
        this.updateAnchorButtonPositions();
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connection) {
        return this.getOutgoingAnchor();
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        return this.getOutgoingAnchor();
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connection) {
        return this.getIncomingAnchor();
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        return this.getIncomingAnchor();
    }
}

