/*
 * Decompiled with CFR 0.152.
 */
package edu.rwth.hci.codegestalt.controller;

import edu.rwth.hci.codegestalt.controller.AbstractCgtGraphicalEditPart;
import edu.rwth.hci.codegestalt.controller.CgtDiagramEditPart;
import edu.rwth.hci.codegestalt.controller.ContextDeletable;
import edu.rwth.hci.codegestalt.controller.command.NoteDeleteCommand;
import edu.rwth.hci.codegestalt.controller.directedit.NoteCellEditorLocator;
import edu.rwth.hci.codegestalt.controller.directedit.NoteDirectEditManager;
import edu.rwth.hci.codegestalt.controller.policy.ContextDeleteSelectionEditPolicy;
import edu.rwth.hci.codegestalt.controller.policy.NoteComponentEditPolicy;
import edu.rwth.hci.codegestalt.controller.policy.NoteDirectEditPolicy;
import edu.rwth.hci.codegestalt.model.Note;
import edu.rwth.hci.codegestalt.view.NoteFigure;
import edu.rwth.hci.codegestalt.view.ui.CloseButtonFigure;
import java.beans.PropertyChangeEvent;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.CommandStack;

public class NoteEditPart
extends AbstractCgtGraphicalEditPart
implements ContextDeletable {
    private CloseButtonFigure closeButton = null;

    public Note getCastedModel() {
        return (Note)this.getModel();
    }

    public NoteFigure getCastedView() {
        return (NoteFigure)this.getFigure();
    }

    private void performDirectEdit() {
        new NoteDirectEditManager((GraphicalEditPart)this, new NoteCellEditorLocator(this.getCastedView())).show();
    }

    private void updateBackgroundPosition() {
        this.getCastedModel().getBackground().setBounds(this.getCastedModel().getBounds());
    }

    private void setViewAlpha(int alpha) {
        this.getCastedModel().getBackground().setAlpha(alpha);
        this.getCastedView().setAlpha(alpha);
    }

    public void activate() {
        if (!this.isActive()) {
            super.activate();
            this.getCastedModel().addPropertyChangeListener(this);
            CommandStack commandStack = this.getRoot().getViewer().getEditDomain().getCommandStack();
            this.closeButton = new CloseButtonFigure(commandStack, new NoteDeleteCommand(((CgtDiagramEditPart)this.getParent()).getCastedModel(), this.getCastedModel()));
            this.updateBackgroundPosition();
        }
    }

    public void deactivate() {
        if (this.isActive()) {
            this.getCastedModel().removePropertyChangeListener(this);
            super.deactivate();
        }
    }

    protected IFigure createFigure() {
        return new NoteFigure(this.getCastedModel().getText());
    }

    protected void createEditPolicies() {
        this.installEditPolicy("GraphicalNodeEditPolicy", null);
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)new NoteDirectEditPolicy());
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new NoteComponentEditPolicy());
        this.installEditPolicy("Selection Feedback", (EditPolicy)new ContextDeleteSelectionEditPolicy());
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        if (evt.getSource() instanceof Note) {
            if (propertyName.equals("edu.rwth.hci.codegestalt.model.Positionable.bounds")) {
                this.refreshVisuals();
            } else if (propertyName.equals("edu.rwth.hci.codegestalt.model.Note.text")) {
                this.getCastedView().setText((String)evt.getNewValue());
            } else if (propertyName.equals("IFadeable.alpha")) {
                this.setViewAlpha((Integer)evt.getNewValue());
            }
        }
    }

    protected void refreshVisuals() {
        this.updateBackgroundPosition();
        ((GraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, this.getFigure(), (Object)this.getCastedModel().getBounds());
        this.updateCloseButtonPosition();
    }

    public void performRequest(Request request) {
        if (request.getType() == "direct edit" || request.getType() == "open") {
            this.performDirectEdit();
        }
    }

    @Override
    public void updateCloseButtonPosition() {
        if (this.isActive()) {
            Point pos = this.getCastedModel().getBounds().getTopRight();
            pos.x -= 16;
            this.getCloseButton().setLocation(pos);
        }
    }

    @Override
    public CloseButtonFigure getCloseButton() {
        return this.closeButton;
    }
}

