/*
 * Decompiled with CFR 0.152.
 */
package edu.rwth.hci.codegestalt.controller;

import edu.rwth.hci.codegestalt.controller.AbstractCgtGraphicalEditPart;
import edu.rwth.hci.codegestalt.controller.policy.CgtXYLayoutEditPolicy;
import edu.rwth.hci.codegestalt.model.CgtDiagram;
import edu.rwth.hci.codegestalt.model.Note;
import edu.rwth.hci.codegestalt.model.Tag;
import edu.rwth.hci.codegestalt.model.Type;
import edu.rwth.hci.codegestalt.model.TypeTagCloud;
import java.beans.PropertyChangeEvent;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ConnectionLayer;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.FreeformLayout;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.editpolicies.RootComponentEditPolicy;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class CgtDiagramEditPart
extends AbstractCgtGraphicalEditPart
implements IElementChangedListener {
    private boolean tagOverlay = false;
    private boolean resolvingConflicts = false;
    private boolean refreshingChildren = false;

    public CgtDiagram getCastedModel() {
        return (CgtDiagram)this.getModel();
    }

    public void activate() {
        if (!this.isActive()) {
            super.activate();
            this.getCastedModel().addPropertyChangeListener(this);
            for (Type type : this.getCastedModel().getTypeChildren()) {
                type.addPropertyChangeListener(this);
            }
            for (Tag tag : this.getCastedModel().getTagChildren().values()) {
                tag.addPropertyChangeListener(this);
            }
            JavaCore.addElementChangedListener((IElementChangedListener)this, (int)1);
        }
    }

    public void deactivate() {
        if (this.isActive()) {
            JavaCore.removeElementChangedListener((IElementChangedListener)this);
            for (Type type : this.getCastedModel().getTypeChildren()) {
                type.removePropertyChangeListener(this);
            }
            for (Tag tag : this.getCastedModel().getTagChildren().values()) {
                tag.removePropertyChangeListener(this);
            }
            this.getCastedModel().removePropertyChangeListener(this);
            super.deactivate();
        }
    }

    protected IFigure createFigure() {
        FreeformLayer f = new FreeformLayer();
        f.setBorder((Border)new MarginBorder(3));
        f.setLayoutManager((LayoutManager)new FreeformLayout());
        ConnectionLayer connLayer = (ConnectionLayer)this.getLayer("Connection Layer");
        connLayer.setConnectionRouter(null);
        return f;
    }

    protected List getModelChildren() {
        if (this.tagOverlay) {
            return this.getCastedModel().getOverlayChildren();
        }
        return this.getCastedModel().getChildren();
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new RootComponentEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new CgtXYLayoutEditPolicy());
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propertyId = evt.getPropertyName();
        if (propertyId.equals("Tag.preferredBoundsProperty") || "CgtDiagram.tagAdded".equals(propertyId) || "CgtDiagram.tagRemoved".equals(propertyId) || "CgtDiagram.tagUnpinned".equals(propertyId)) {
            this.checkAndFixTagLayout();
        }
        if (propertyId.equals("CgtDiagram.tagAdded")) {
            ((Tag)evt.getNewValue()).addPropertyChangeListener(this);
        }
        if (propertyId.equals("CgtDiagram.tagRemoved")) {
            ((Tag)evt.getNewValue()).removePropertyChangeListener(this);
        }
        if (propertyId.equals("CgtDiagram.typeAdded")) {
            ((Type)evt.getNewValue()).addPropertyChangeListener(this);
        }
        if (propertyId.equals("CgtDiagram.typeRemoved")) {
            ((Type)evt.getNewValue()).removePropertyChangeListener(this);
        }
        if (propertyId.equals("CgtDiagram.tagAdded") || propertyId.equals("CgtDiagram.tagRemoved") || propertyId.equals("CgtDiagram.typeAdded") || propertyId.equals("CgtDiagram.typeRemoved") || "CgtDiagram.tagShown".equals(propertyId) || "CgtDiagram.tagHidden".equals(propertyId) || "CgtDiagram.tagUnpinned".equals(propertyId) || "CgtDiagram.tagRegionAdded".equals(propertyId) || "CgtDiagram.tagRegionRemoved".equals(propertyId) || "CgtDiagram.noteAdded".equals(propertyId) || "CgtDiagram.noteRemoved".equals(propertyId)) {
            this.refreshChildren();
        }
        if (propertyId.equals("Type.tagCloudChanged")) {
            this.getCastedModel().updateTagsForType((Type)evt.getSource(), (TypeTagCloud)evt.getOldValue());
        }
    }

    public void elementChanged(ElementChangedEvent event) {
        this.processJavaElementDelta(event.getDelta());
    }

    public void processJavaElementDelta(IJavaElementDelta delta) {
        IJavaElement changedElement = delta.getElement();
        switch (changedElement.getElementType()) {
            case 1: 
            case 2: 
            case 3: {
                this.processJavaElementDeltaChildren(delta.getAffectedChildren());
                break;
            }
            case 4: {
                this.processPackageFragmentChange(delta);
                break;
            }
            case 5: {
                this.processCompilationUnitChange(delta);
                break;
            }
            case 7: {
                this.processTypeDeltaChange(delta);
                break;
            }
            case 9: {
                this.processMethodChange(delta);
                break;
            }
        }
    }

    private void processJavaElementDeltaChildren(IJavaElementDelta[] affectedChildren) {
        IJavaElementDelta[] iJavaElementDeltaArray = affectedChildren;
        int n = affectedChildren.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElementDelta delta = iJavaElementDeltaArray[n2];
            this.processJavaElementDelta(delta);
            ++n2;
        }
    }

    private void processPackageFragmentChange(IJavaElementDelta delta) {
        IPackageFragment packageFragment = (IPackageFragment)delta.getElement();
        switch (delta.getKind()) {
            case 2: {
                this.getCastedModel().removeJdtPackage(packageFragment);
            }
        }
        this.processJavaElementDeltaChildren(delta.getAffectedChildren());
    }

    private void processCompilationUnitChange(IJavaElementDelta delta) {
        ICompilationUnit unit = (ICompilationUnit)delta.getElement();
        switch (delta.getKind()) {
            case 2: {
                this.getCastedModel().removeJdtCompilationUnit(unit);
                break;
            }
            case 4: {
                IJavaElementDelta[] removedChildren;
                IJavaElementDelta[] iJavaElementDeltaArray = removedChildren = delta.getRemovedChildren();
                int n = removedChildren.length;
                int n2 = 0;
                while (n2 < n) {
                    IJavaElementDelta removedChild = iJavaElementDeltaArray[n2];
                    if (removedChild.getElement() instanceof IType) {
                        this.getCastedModel().removeJdtType((IType)removedChild.getElement());
                    }
                    ++n2;
                }
                break;
            }
        }
        this.processJavaElementDeltaChildren(delta.getAffectedChildren());
    }

    private void processTypeDeltaChange(IJavaElementDelta delta) {
        switch (delta.getKind()) {
            case 2: {
                this.getCastedModel().removeJdtType((IType)delta.getElement());
            }
        }
        this.processJavaElementDeltaChildren(delta.getAffectedChildren());
    }

    private void processMethodChange(IJavaElementDelta delta) {
    }

    public void setTagOverlay(boolean b) {
        if (b != this.tagOverlay) {
            this.tagOverlay = b;
            this.fadeTypes(this.tagOverlay);
            this.fadeNotes(this.tagOverlay);
            this.notifyTagsAboutTagOverlayChange(this.tagOverlay);
            if (b) {
                this.checkAndFixTagLayout();
            }
            this.refreshChildren();
        }
    }

    public boolean isTagOverlay() {
        return this.tagOverlay;
    }

    private void fadeTypes(boolean tagOverlay) {
        int alpha = tagOverlay ? 63 : 255;
        for (Type type : this.getCastedModel().getTypeChildren()) {
            type.setAlpha(alpha);
        }
    }

    private void fadeNotes(boolean tagOverlay) {
        int alpha = tagOverlay ? 63 : 255;
        for (Note note : this.getCastedModel().getNoteChildren()) {
            note.setAlpha(alpha);
        }
    }

    private void notifyTagsAboutTagOverlayChange(boolean tagOverlay) {
        for (Tag tag : this.getCastedModel().getTagChildren().values()) {
            tag.fireTagOverlay(tagOverlay);
        }
    }

    private void checkAndFixTagLayout() {
        if (!this.resolvingConflicts && !this.refreshingChildren && this.tagOverlay) {
            this.resolvingConflicts = true;
            this.initTagLayoutBoundsWithPreferredBounds();
            SortedSet<SortedSet<Tag>> conflictsList = this.findTagLayoutConflicts();
            this.resolveTagLayoutConflicts(conflictsList);
            this.applyLayoutToTagBounds();
            this.resolvingConflicts = false;
        }
    }

    private void initTagLayoutBoundsWithPreferredBounds() {
        for (Tag tag : this.getCastedModel().getShownTagChildren()) {
            tag.setLayoutBounds(tag.getPreferredBounds());
        }
    }

    private void applyLayoutToTagBounds() {
        for (Tag tag : this.getCastedModel().getShownTagChildren()) {
            if (tag.isPinned()) continue;
            tag.setBounds(tag.getLayoutBounds());
        }
    }

    private void resolveTagLayoutConflicts(SortedSet<SortedSet<Tag>> conflictList) {
        for (SortedSet sortedSet : conflictList) {
            int totalHeight = 0;
            int totalTopY = 0;
            for (Tag tag : sortedSet) {
                totalHeight += tag.getLayoutBounds().height;
                totalTopY += tag.getLayoutBounds().y;
            }
            int yCenterOfGravity = Math.round((totalTopY + totalHeight / 2) / sortedSet.size());
            int yStart = yCenterOfGravity - Math.round((totalHeight + sortedSet.size()) / 2);
            for (Tag tag : sortedSet) {
                Rectangle newLayoutBounds = tag.getLayoutBounds();
                newLayoutBounds.y = yStart;
                tag.setLayoutBounds(newLayoutBounds);
                yStart += newLayoutBounds.height + 1;
            }
        }
    }

    private SortedSet<SortedSet<Tag>> findTagLayoutConflicts() {
        class TagTermComparator
        implements Comparator<Tag>,
        Serializable {
            private static final long serialVersionUID = 1L;

            TagTermComparator() {
            }

            @Override
            public int compare(Tag object0, Tag object1) {
                return object0.getTerm().compareTo(object1.getTerm());
            }
        }
        TreeMap<Tag, SortedSet<Tag>> conflictMap = new TreeMap<Tag, SortedSet<Tag>>(new TagTermComparator());
        class TagSetYComparator
        implements Comparator<SortedSet<Tag>>,
        Serializable {
            private static final long serialVersionUID = 1L;

            TagSetYComparator() {
            }

            @Override
            public int compare(SortedSet<Tag> object0, SortedSet<Tag> object1) {
                if (object0.size() > 0 && object1.size() > 0) {
                    Tag tag0 = object0.first();
                    Tag tag1 = object1.first();
                    if (tag0.getLayoutBounds().getCenter().y != tag1.getLayoutBounds().getCenter().y) {
                        return (int)Math.signum(tag0.getLayoutBounds().getCenter().y - tag1.getLayoutBounds().getCenter().y);
                    }
                    return tag0.getTerm().compareTo(tag1.getTerm());
                }
                if (object1.size() == 0) {
                    return -1;
                }
                if (object0.size() == 0) {
                    return 1;
                }
                return 0;
            }
        }
        TreeSet<SortedSet<Tag>> conflictList = new TreeSet<SortedSet<Tag>>(new TagSetYComparator());
        class TagXComparator
        implements Comparator<Tag>,
        Serializable {
            private static final long serialVersionUID = 1L;

            TagXComparator() {
            }

            @Override
            public int compare(Tag object0, Tag object1) {
                if (object0.getLayoutBounds().x != object1.getLayoutBounds().x) {
                    return (int)Math.signum(object0.getLayoutBounds().x - object1.getLayoutBounds().x);
                }
                if (object0.getLayoutBounds().y != object1.getLayoutBounds().y) {
                    return (int)Math.signum(object0.getLayoutBounds().y - object1.getLayoutBounds().y);
                }
                return object0.getTerm().compareTo(object1.getTerm());
            }
        }
        TreeSet<Tag> xSet = new TreeSet<Tag>(new TagXComparator());
        xSet.addAll(this.getCastedModel().getShownTagChildren());
        this.findTagLayoutConflictsXDirection(xSet, conflictMap, conflictList);
        return conflictList;
    }

    private void findTagLayoutConflictsXDirection(TreeSet<Tag> xSet, TreeMap<Tag, SortedSet<Tag>> conflictMap, SortedSet<SortedSet<Tag>> conflictList) {
        class TagXStartComparator
        implements Comparator<Tag>,
        Serializable {
            private static final long serialVersionUID = 1L;

            TagXStartComparator() {
            }

            @Override
            public int compare(Tag object0, Tag object1) {
                if (object0.getLayoutBounds().x != object1.getLayoutBounds().x) {
                    return (int)Math.signum(object0.getLayoutBounds().x - object1.getLayoutBounds().x);
                }
                if (object0.getLayoutBounds().y != object1.getLayoutBounds().y) {
                    return (int)Math.signum(object0.getLayoutBounds().y - object1.getLayoutBounds().y);
                }
                return object0.getTerm().compareTo(object1.getTerm());
            }
        }
        TreeSet<Tag> tagXStart = new TreeSet<Tag>(new TagXStartComparator());
        class TagXEndComparator
        implements Comparator<Tag>,
        Serializable {
            private static final long serialVersionUID = 1L;

            TagXEndComparator() {
            }

            @Override
            public int compare(Tag object0, Tag object1) {
                if (object0.getLayoutBounds().right() != object1.getLayoutBounds().right()) {
                    return (int)Math.signum(object0.getLayoutBounds().right() - object1.getLayoutBounds().right());
                }
                if (object0.getLayoutBounds().y != object1.getLayoutBounds().y) {
                    return (int)Math.signum(object0.getLayoutBounds().y - object1.getLayoutBounds().y);
                }
                return object0.getTerm().compareTo(object1.getTerm());
            }
        }
        TreeSet<Tag> tagXEnd = new TreeSet<Tag>(new TagXEndComparator());
        for (Tag tag : xSet) {
            tagXStart.add(tag);
            tagXEnd.add(tag);
        }
        class TagYComparator
        implements Comparator<Tag>,
        Serializable {
            private static final long serialVersionUID = 1L;

            TagYComparator() {
            }

            @Override
            public int compare(Tag object0, Tag object1) {
                if (object0.getLayoutBounds().y != object1.getLayoutBounds().y) {
                    return (int)Math.signum(object0.getLayoutBounds().y - object1.getLayoutBounds().y);
                }
                if (object0.getLayoutBounds().x != object1.getLayoutBounds().x) {
                    return (int)Math.signum(object0.getLayoutBounds().x - object1.getLayoutBounds().x);
                }
                return object0.getTerm().compareTo(object1.getTerm());
            }
        }
        TreeSet<Tag> intersection = new TreeSet<Tag>(new TagYComparator());
        while (tagXStart.size() != 0) {
            Tag tag;
            if (tagXStart.size() <= 0) continue;
            if (tagXStart.first().getLayoutBounds().x <= tagXEnd.first().getLayoutBounds().right()) {
                tag = tagXStart.first();
                intersection.add(tag);
                tagXStart.remove(tag);
            } else {
                tag = tagXEnd.first();
                intersection.remove(tag);
                tagXEnd.remove(tag);
            }
            this.findTagLayoutConflictsYDirection(intersection, conflictMap, conflictList);
        }
    }

    private void findTagLayoutConflictsYDirection(TreeSet<Tag> ySet, TreeMap<Tag, SortedSet<Tag>> conflictMap, SortedSet<SortedSet<Tag>> conflictList) {
        class TagYStartComparator
        implements Comparator<Tag>,
        Serializable {
            private static final long serialVersionUID = 1L;

            TagYStartComparator() {
            }

            @Override
            public int compare(Tag object0, Tag object1) {
                if (object0.getLayoutBounds().y != object1.getLayoutBounds().y) {
                    return (int)Math.signum(object0.getLayoutBounds().y - object1.getLayoutBounds().y);
                }
                if (object0.getLayoutBounds().x != object1.getLayoutBounds().x) {
                    return (int)Math.signum(object0.getLayoutBounds().x - object1.getLayoutBounds().x);
                }
                return object0.getTerm().compareTo(object1.getTerm());
            }
        }
        TreeSet<Tag> tagYStart = new TreeSet<Tag>(new TagYStartComparator());
        class TagYEndComparator
        implements Comparator<Tag>,
        Serializable {
            private static final long serialVersionUID = 1L;

            TagYEndComparator() {
            }

            @Override
            public int compare(Tag object0, Tag object1) {
                if (object0.getLayoutBounds().bottom() != object1.getLayoutBounds().bottom()) {
                    return (int)Math.signum(object0.getLayoutBounds().bottom() - object1.getLayoutBounds().bottom());
                }
                if (object0.getLayoutBounds().x != object1.getLayoutBounds().x) {
                    return (int)Math.signum(object0.getLayoutBounds().x - object1.getLayoutBounds().x);
                }
                return object0.getTerm().compareTo(object1.getTerm());
            }
        }
        TreeSet<Tag> tagYEnd = new TreeSet<Tag>(new TagYEndComparator());
        for (Tag tag : ySet) {
            tagYStart.add(tag);
            tagYEnd.add(tag);
        }
        class TagYComparator
        implements Comparator<Tag>,
        Serializable {
            private static final long serialVersionUID = 1L;

            TagYComparator() {
            }

            @Override
            public int compare(Tag object0, Tag object1) {
                if (object0.getLayoutBounds().y != object1.getLayoutBounds().y) {
                    return (int)Math.signum(object0.getLayoutBounds().y - object1.getLayoutBounds().y);
                }
                if (object0.getLayoutBounds().x != object1.getLayoutBounds().x) {
                    return (int)Math.signum(object0.getLayoutBounds().x - object1.getLayoutBounds().x);
                }
                return object0.getTerm().compareTo(object1.getTerm());
            }
        }
        TreeSet<Tag> intersection = new TreeSet<Tag>(new TagYComparator());
        while (tagYStart.size() != 0) {
            SortedSet<Tag> conflictSet;
            Tag tag;
            if (tagYStart.size() <= 0) continue;
            if (tagYStart.first().getLayoutBounds().y <= tagYEnd.first().getLayoutBounds().bottom()) {
                tag = tagYStart.first();
                intersection.add(tag);
                tagYStart.remove(tag);
            } else {
                tag = tagYEnd.first();
                intersection.remove(tag);
                tagYEnd.remove(tag);
            }
            if (intersection.size() <= 0) continue;
            if (conflictMap.containsKey(intersection.first())) {
                conflictSet = conflictMap.get(intersection.first());
                conflictList.remove(conflictSet);
            } else {
                class TagYLocationComparator
                implements Comparator<Tag>,
                Serializable {
                    private static final long serialVersionUID = 1L;

                    TagYLocationComparator() {
                    }

                    @Override
                    public int compare(Tag object0, Tag object1) {
                        if (object0.getLayoutBounds().getCenter().y != object1.getLayoutBounds().getCenter().y) {
                            return (int)Math.signum(object0.getLayoutBounds().getCenter().y - object1.getLayoutBounds().getCenter().y);
                        }
                        return object0.getTerm().compareTo(object1.getTerm());
                    }
                }
                conflictSet = new TreeSet<Tag>(new TagYLocationComparator());
            }
            for (Tag tag2 : intersection) {
                if (!conflictSet.contains(tag2)) {
                    conflictSet.add(tag2);
                }
                if (conflictMap.containsKey(tag2) && !conflictMap.get(tag2).equals(conflictSet)) {
                    Set obsoleteConflictSet = conflictMap.get(tag2);
                    for (Tag tag22 : obsoleteConflictSet) {
                        if (conflictSet.contains(tag22)) continue;
                        conflictSet.add(tag22);
                        conflictMap.remove(tag22);
                        conflictMap.put(tag22, conflictSet);
                    }
                    conflictMap.remove(tag2);
                    conflictList.remove(obsoleteConflictSet);
                }
                conflictMap.put(tag2, conflictSet);
            }
            conflictList.add(conflictSet);
        }
    }

    public void exportImage() {
        int format = 5;
        IFigure figure = this.getLayer("Printable Layers");
        Display device = this.getViewer().getControl().getDisplay();
        Rectangle r = figure.getBounds();
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        Image image = null;
        GC gc = null;
        SWTGraphics g = null;
        try {
            image = new Image((Device)device, r.width, r.height);
            gc = new GC((Drawable)image);
            g = new SWTGraphics(gc);
            g.translate(r.x * -1, r.y * -1);
            figure.paint((Graphics)g);
            ImageLoader imageLoader = new ImageLoader();
            imageLoader.data = new ImageData[]{image.getImageData()};
            imageLoader.save((OutputStream)result, format);
            try {
                FileDialog dialog = new FileDialog(new Shell(Display.getDefault()), 8192);
                dialog.setFilterNames(new String[]{"Portable Network Graphics", "All Files"});
                dialog.setFilterExtensions(new String[]{"*.png", "*.*"});
                String strFilePath = dialog.open();
                if (strFilePath != null) {
                    FileOutputStream fos = new FileOutputStream(strFilePath);
                    fos.write(result.toByteArray());
                    fos.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        finally {
            if (g != null) {
                g.dispose();
            }
            if (gc != null) {
                gc.dispose();
            }
            if (image != null) {
                image.dispose();
            }
        }
    }
}

