/*
 * Decompiled with CFR 0.152.
 */
package edu.rwth.hci.codegestalt.controller;

import edu.rwth.hci.codegestalt.controller.command.CallRelationPermanentCommand;
import edu.rwth.hci.codegestalt.controller.policy.CallRelationConnectionEditPolicy;
import edu.rwth.hci.codegestalt.controller.policy.CallRelationSelectionEditPolicy;
import edu.rwth.hci.codegestalt.controller.policy.FixedConnectionEndpointEditPolicy;
import edu.rwth.hci.codegestalt.model.CallRelation;
import edu.rwth.hci.codegestalt.view.CallRelationFigure;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.LinkedList;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.editparts.AbstractConnectionEditPart;

public class CallRelationEditPart
extends AbstractConnectionEditPart
implements PropertyChangeListener {
    public CallRelation getCastedModel() {
        return (CallRelation)this.getModel();
    }

    public CallRelationFigure getCastedView() {
        return (CallRelationFigure)this.getFigure();
    }

    public void activate() {
        if (!this.isActive()) {
            super.activate();
            this.getCastedModel().addPropertyChangeListener(this);
        }
    }

    public void deactivate() {
        if (this.isActive()) {
            this.getCastedModel().removePropertyChangeListener(this);
            super.deactivate();
        }
    }

    protected void createEditPolicies() {
        this.installEditPolicy("Connection Endpoint Policy", (EditPolicy)new FixedConnectionEndpointEditPolicy());
        this.installEditPolicy("ConnectionEditPolicy", (EditPolicy)new CallRelationConnectionEditPolicy());
        this.installEditPolicy("Selection Feedback", (EditPolicy)new CallRelationSelectionEditPolicy());
    }

    protected IFigure createFigure() {
        CommandStack commandStack = this.getRoot().getViewer().getEditDomain().getCommandStack();
        CallRelationFigure connection = new CallRelationFigure(commandStack, this.getCastedModel().isPermanent() ? null : this.createViewCommand());
        if (this.getCastedModel().isPermanent()) {
            connection.setToolTip((IFigure)this.createViewToolTip());
        }
        connection.setAntialias(1);
        if (!this.getCastedModel().isPermanent()) {
            connection.setForegroundColor(ColorConstants.lightGray);
        }
        PolygonDecoration arrow = new PolygonDecoration();
        arrow.setAntialias(1);
        connection.setTargetDecoration((RotatableDecoration)arrow);
        return connection;
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        String prop = event.getPropertyName();
        if ("CallRelation.setToPermanent".equals(prop)) {
            this.getCastedView().setForegroundColor(ColorConstants.black);
            this.getCastedView().setCommand(null);
            this.getCastedView().setToolTip((IFigure)this.createViewToolTip());
        } else if ("CallRelation.setToPreview".equals(prop)) {
            this.getCastedView().setForegroundColor(ColorConstants.lightGray);
            if (!this.getTarget().hasFocus() && !this.getSource().hasFocus()) {
                this.getCastedModel().detach();
                this.getCastedView().setCommand(this.createViewCommand());
            }
        } else if ("IFadeable.alpha".equals(prop)) {
            this.setViewAlpha(this.getCastedModel().getAlpha());
        }
    }

    private void setViewAlpha(int alpha) {
        this.getCastedView().setAlpha(alpha);
    }

    private Command createViewCommand() {
        LinkedList<CallRelation> relations = new LinkedList<CallRelation>();
        relations.add(this.getCastedModel());
        return new CallRelationPermanentCommand(relations);
    }

    private Figure createViewToolTip() {
        return new Label("Method \"" + this.getCastedModel().getCaller().toString() + "\" calls method \"" + this.getCastedModel().getCallee().toString() + "\".");
    }
}

