/*
 * Decompiled with CFR 0.152.
 */
package edu.rwth.hci.codegestalt.wizard;

import edu.rwth.hci.codegestalt.controller.command.DiagramChildrenCreateCommand;
import edu.rwth.hci.codegestalt.model.CgtDiagram;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.plugin.AbstractUIPlugin;

class CgtWizardFileCreationPage
extends WizardNewFileCreationPage {
    private final String defaultFileName;
    private StructuredSelection selection = null;
    private CgtDiagram diagram = null;
    private boolean userPreference = false;
    private int userPreferenceMembers = 0;

    public CgtWizardFileCreationPage(IStructuredSelection selection, String defaultFileName, boolean userPreference, int userPreferenceMembers) {
        super("CgtWizardFileCreationPage", selection);
        if (selection instanceof StructuredSelection) {
            this.selection = (StructuredSelection)selection;
        }
        this.defaultFileName = defaultFileName;
        this.userPreference = userPreference;
        this.userPreferenceMembers = userPreferenceMembers;
        this.setTitle("Code Gestalt Diagram");
        this.setDescription("Create a new Code Gestalt diagram.");
        ImageDescriptor image = AbstractUIPlugin.imageDescriptorFromPlugin((String)"edu.rwth.hci.codegestalt", (String)"icons/CgtWizard.png");
        this.setImageDescriptor(image);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.setFileName(this.defaultFileName);
        this.setPageComplete(this.validatePage());
    }

    protected InputStream getInitialContents() {
        ByteArrayInputStream bais = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    CgtWizardFileCreationPage.this.buildNewDiagram();
                }
            });
            oos.writeObject(this.diagram);
            oos.flush();
            oos.close();
            bais = new ByteArrayInputStream(baos.toByteArray());
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return bais;
    }

    private void buildNewDiagram() {
        this.diagram = new CgtDiagram();
        DiagramChildrenCreateCommand populateCommand = this.userPreference ? new DiagramChildrenCreateCommand(this.selection, this.diagram, new Point(Display.getCurrent().getClientArea().width / 4, Display.getCurrent().getClientArea().height / 4), this.userPreferenceMembers) : new DiagramChildrenCreateCommand(this.selection, this.diagram, new Point(Display.getCurrent().getClientArea().width / 4, Display.getCurrent().getClientArea().height / 4));
        if (populateCommand.canExecute()) {
            populateCommand.execute();
        }
    }
}

