/*
 * Decompiled with CFR 0.152.
 */
package edu.rwth.hci.codegestalt.view.ui;

import edu.rwth.hci.codegestalt.Activator;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.handles.RelativeHandleLocator;
import org.eclipse.gef.handles.ResizeHandle;
import org.eclipse.swt.graphics.Image;

public class TypeResizeHandle
extends ResizeHandle {
    private static final Image RESIZE = Activator.getImageDescriptor("icons/ResizeHandle.png").createImage();

    public TypeResizeHandle(GraphicalEditPart owner, int direction) {
        super(owner, direction);
        this.setPreferredSize(16, 16);
        this.setLocator((Locator)new TypeResizeHandleLocator(owner.getFigure(), direction));
    }

    public void paintFigure(Graphics graphics) {
        graphics.drawImage(RESIZE, 0, 0, 16, 16, this.getBounds().x, this.getBounds().y, 16, 16);
    }

    private class TypeResizeHandleLocator
    extends RelativeHandleLocator {
        public TypeResizeHandleLocator(IFigure reference, int location) {
            super(reference, location);
        }

        public void relocate(IFigure target) {
            IFigure reference = this.getReferenceFigure();
            PrecisionRectangle targetBounds = new PrecisionRectangle(this.getReferenceBox().getResized(-1, -1));
            reference.translateToAbsolute((Translatable)targetBounds);
            target.translateToRelative((Translatable)targetBounds);
            targetBounds.resize(1, 1);
            Dimension targetSize = target.getPreferredSize();
            targetBounds.x += targetBounds.width - (targetSize.width + 1);
            targetBounds.y += targetBounds.height - (targetSize.height + 1);
            targetBounds.setSize(targetSize);
            target.setBounds((Rectangle)targetBounds);
        }
    }
}

