/*
 * Decompiled with CFR 0.152.
 */
package edu.rwth.hci.codegestalt.view.ui;

import edu.rwth.hci.codegestalt.Activator;
import edu.rwth.hci.codegestalt.controller.command.ColorChangeCommand;
import edu.rwth.hci.codegestalt.view.ui.AbstractContextButtonFigure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ImageFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ColorButtonFigure
extends AbstractContextButtonFigure {
    private static final Image defaultIcon = Activator.getImageDescriptor("icons/PaletteDefault16.png").createImage();
    private static final Image hoverIcon = Activator.getImageDescriptor("icons/PaletteHover16.png").createImage();
    ImageFigure iconFigure = null;
    RGB color = null;

    public ColorButtonFigure(CommandStack commandStack, ColorChangeCommand recolorCommand, RGB color) {
        super(commandStack, recolorCommand);
        this.color = color;
        this.setSize(16, 16);
        this.setOutline(false);
        this.setFill(false);
        this.setLayoutManager((LayoutManager)new ToolbarLayout());
        this.iconFigure = new ImageFigure(defaultIcon);
        this.add((IFigure)this.iconFigure);
        this.iconFigure.setToolTip((IFigure)new Label("Change Tag Region Color"));
    }

    public RGB getColor() {
        return this.color;
    }

    public void setColor(RGB color) {
        this.color = color;
    }

    @Override
    public void showDefaultGraphics() {
        this.iconFigure.setImage(defaultIcon);
    }

    @Override
    public void showHoverGraphics() {
        this.iconFigure.setImage(hoverIcon);
    }

    @Override
    public void mousePressed(MouseEvent me) {
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                ColorDialog palette = new ColorDialog(new Shell(Display.getDefault()));
                palette.setRGB(ColorButtonFigure.this.getColor());
                palette.setText("Choose a Color");
                RGB color = palette.open();
                if (color != null) {
                    ColorChangeCommand command = (ColorChangeCommand)((ColorChangeCommand)ColorButtonFigure.this.getCommand()).clone();
                    command.setColor(color);
                    ColorButtonFigure.this.getCommandStack().execute((Command)command);
                }
            }
        });
    }
}

