/*
 * Decompiled with CFR 0.152.
 */
package edu.rwth.hci.codegestalt.view;

import java.util.SortedMap;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Display;

public class TypeTagCloudFigure
extends Figure {
    private FlowLayout layout = new FlowLayout(true);

    public TypeTagCloudFigure() {
        this.layout.setMajorAlignment(1);
        this.layout.setMinorAlignment(2);
        this.setLayoutManager((LayoutManager)this.layout);
        Label wait = new Label("Please wait. Fetching tags...");
        wait.setFont(new Font((Device)Display.getDefault(), Display.getDefault().getSystemFont().getFontData()));
        this.add((IFigure)wait);
    }

    public void setTags(SortedMap<String, Double> tags) {
        for (Object o : this.getChildren()) {
            ((Label)o).getFont().dispose();
        }
        this.removeAll();
        double maxWeight = this.maxWeight(tags);
        if (tags.size() == 0) {
            Label wait = new Label("Please wait. Fetching tags...");
            wait.setFont(new Font((Device)Display.getDefault(), Display.getDefault().getSystemFont().getFontData()));
            this.add((IFigure)wait);
        } else {
            for (String tag : tags.keySet()) {
                Label tagFigure = new Label(tag);
                Font systemFont = Display.getDefault().getSystemFont();
                int height = (int)(8.0 + 8.0 * ((Double)tags.get(tag) / maxWeight));
                FontData[] fontData = systemFont.getFontData();
                int i = 0;
                while (i < fontData.length) {
                    fontData[i].setHeight(height);
                    ++i;
                }
                Font labelFont = new Font((Device)Display.getDefault(), fontData);
                tagFigure.setFont(labelFont);
                this.add((IFigure)tagFigure);
            }
        }
        this.setPreferredSize(this.layout.getMinimumSize((IFigure)this, this.getSize().width, -1));
    }

    private double maxWeight(SortedMap<String, Double> tags) {
        double result = 0.001;
        for (Double weight : tags.values()) {
            result = Math.max(result, weight);
        }
        return result;
    }

    public void setAlpha(int alpha) {
        for (Object child : this.getChildren()) {
            if (!(child instanceof Label)) continue;
            Label tag = (Label)child;
            Color oldColor = tag.getForegroundColor();
            tag.setForegroundColor(new Color((Device)Display.getDefault(), 255 - alpha, 255 - alpha, 255 - alpha));
            oldColor.dispose();
        }
    }
}

